% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{AddSamples}
\alias{AddSamples}
\title{Add samples into existing Seurat object.}
\usage{
AddSamples(object, new.data, project = NULL, min.cells = 0, min.genes = 0,
  is.expr = 0, do.normalize = TRUE, scale.factor = 10000,
  do.scale = FALSE, do.center = FALSE, names.field = 1,
  names.delim = "_", meta.data = NULL, add.cell.id = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{new.data}{Data matrix for samples to be added}

\item{project}{Project name (string)}

\item{min.cells}{Include genes with detected expression in at least this
many cells}

\item{min.genes}{Include cells where at least this many genes are detected}

\item{is.expr}{Expression threshold for 'detected' gene}

\item{do.normalize}{Normalize the data after merging. Default is TRUE.
If set, will perform the same normalization strategy as stored in the object}

\item{scale.factor}{scale factor in the log normalization}

\item{do.scale}{In object@scale.data, perform row-scaling (gene-based z-score)}

\item{do.center}{In object@scale.data, perform row-centering (gene-based
centering)}

\item{names.field}{For the initial identity class for each cell, choose this
field from the cell's column name}

\item{names.delim}{For the initial identity class for each cell, choose this
delimiter from the cell's column name}

\item{meta.data}{Additional metadata to add to the Seurat object. Should be
a data frame where the rows are cell names, and the columns are additional
metadata fields}

\item{add.cell.id}{String to be appended to the names of all cells in
new.data. E.g. if add.cell.id = "rep1", "cell1" becomes "cell1.rep1"}
}
\description{
Add samples into existing Seurat object.
}
\examples{
pbmc1 <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[1:40])
pbmc1
pbmc2 <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[41:80])
pbmc2_data <- pbmc2@data
dim(pbmc2_data)
pbmc_added <- AddSamples(object = pbmc1, new.data = pbmc2_data)
pbmc_added

}
