% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{NormalizeData}
\alias{NormalizeData}
\title{Normalize Assay Data}
\usage{
NormalizeData(object, assay.type = "RNA",
  normalization.method = "LogNormalize", scale.factor = 10000,
  display.progress = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{assay.type}{Type of assay to normalize for (default is RNA), but can be
changed for multimodal analyses.}

\item{normalization.method}{Method for normalization. Default is
log-normalization (LogNormalize). More methods to be added very shortly.}

\item{scale.factor}{Sets the scale factor for cell-level normalization}

\item{display.progress}{display progress bar for scaling procedure.}
}
\value{
Returns object after normalization. Normalized data is stored in data slot
}
\description{
Normalize data for a given assay
}
\examples{
pbmc_small
pmbc_small <- NormalizeData(object = pbmc_small)

}
