% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{JackStrawPlot}
\alias{JackStrawPlot}
\title{JackStraw Plot}
\usage{
JackStrawPlot(object, PCs = 1:5, nCol = 3, score.thresh = 1e-05,
  plot.x.lim = 0.1, plot.y.lim = 0.3)
}
\arguments{
\item{object}{Seurat plot}

\item{PCs}{Which PCs to examine}

\item{nCol}{Number of columns}

\item{score.thresh}{Threshold to use for the proportion test of PC
significance (see Details)}

\item{plot.x.lim}{X-axis maximum on each QQ plot.}

\item{plot.y.lim}{Y-axis maximum on each QQ plot.}
}
\value{
Returns a Seurat object where object@dr$pca@jackstraw@overall.p.values
represents p-values for each PC and object@dr$pca@misc$jackstraw.plot 
stores the ggplot2 plot.
}
\description{
Plots the results of the JackStraw analysis for PCA significance. For each
PC, plots a QQ-plot comparing the distribution of p-values for all genes
across each PC, compared with a uniform distribution. Also determines a
p-value for the overall significance of each PC (see Details).
}
\details{
Significant PCs should show a p-value distribution (black curve) that is
strongly skewed to the left compared to the null distribution (dashed line)
The p-value for each PC is based on a proportion test comparing the number
of genes with a p-value below a particular threshold (score.thresh), compared with the
proportion of genes expected under a uniform distribution of p-values.
}
\examples{
JackStrawPlot(object = pbmc_small)

}
\author{
Thanks to Omri Wurtzel for integrating with ggplot
}
