% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{CellCycleScoring}
\alias{CellCycleScoring}
\title{Score cell cycle phases}
\usage{
CellCycleScoring(object, s.features, g2m.features, set.ident = FALSE,
  ...)
}
\arguments{
\item{object}{A Seurat object}

\item{s.features}{A vector of features associated with S phase}

\item{g2m.features}{A vector of features associated with G2M phase}

\item{set.ident}{If true, sets identity to phase assignments}

\item{...}{Arguments to be passed to \code{\link{AddModuleScore}}
Stashes old identities in 'old.ident'}
}
\value{
A Seurat object with the following columns added to object meta data: S.Score, G2M.Score, and Phase
}
\description{
Score cell cycle phases
}
\examples{
\dontrun{
# pbmc_small doesn't have any cell-cycle genes
# To run CellCycleScoring, please use a dataset with cell-cycle genes
# An example is available at http://satijalab.org/seurat/cell_cycle_vignette.html
pbmc_small <- CellCycleScoring(
  object = pbmc_small,
  g2m.features = cc.genes$g2m.genes,
  s.features = cc.genes$s.genes
)
head(x = pbmc_small@meta.data)
}

}
\seealso{
\code{AddModuleScore}
}
