% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{FindTransferAnchors}
\alias{FindTransferAnchors}
\title{Find transfer anchors}
\usage{
FindTransferAnchors(
  reference,
  query,
  normalization.method = c("LogNormalize", "SCT"),
  reference.assay = NULL,
  query.assay = NULL,
  reduction = "pcaproject",
  project.query = FALSE,
  features = NULL,
  npcs = 30,
  l2.norm = TRUE,
  dims = 1:30,
  k.anchor = 5,
  k.filter = 200,
  k.score = 30,
  max.features = 200,
  nn.method = "rann",
  eps = 0,
  approx.pca = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{reference}{Seurat object to use as the reference}

\item{query}{Seurat object to use as the query}

\item{normalization.method}{Name of normalization method used: LogNormalize or SCT}

\item{reference.assay}{Assay to use from reference}

\item{query.assay}{Assay to use from query}

\item{reduction}{Dimensional reduction to perform when finding anchors. Options are:
\itemize{
   \item{pcaproject: Project the PCA from the reference onto the query. We recommend using PCA
   when reference and query datasets are from scRNA-seq}
   \item{cca: Run a CCA on the reference and query }
}}

\item{project.query}{Project the PCA from the query dataset onto the reference. Use only in rare
cases where the query dataset has a much larger cell number, but the reference dataset has a
unique assay for transfer.}

\item{features}{Features to use for dimensional reduction}

\item{npcs}{Number of PCs to compute on reference. If null, then use an existing PCA structure in
the reference object}

\item{l2.norm}{Perform L2 normalization on the cell embeddings after dimensional reduction}

\item{dims}{Which dimensions to use from the reduction to specify the neighbor search space}

\item{k.anchor}{How many neighbors (k) to use when picking anchors}

\item{k.filter}{How many neighbors (k) to use when filtering anchors}

\item{k.score}{How many neighbors (k) to use when scoring anchors}

\item{max.features}{The maximum number of features to use when specifying the neighborhood search
space in the anchor filtering}

\item{nn.method}{Method for nearest neighbor finding. Options include: rann,
annoy}

\item{eps}{Error bound on the neighbor finding algorithm (from RANN)}

\item{approx.pca}{Use truncated singular value decomposition to approximate PCA}

\item{verbose}{Print progress bars and output}
}
\value{
Returns an AnchorSet object
}
\description{
Finds the transfer anchors
}
