% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{PolyFeaturePlot}
\alias{PolyFeaturePlot}
\title{Polygon FeaturePlot}
\usage{
PolyFeaturePlot(
  object,
  features,
  cells = NULL,
  poly.data = "spatial",
  ncol = ceiling(x = length(x = features)/2),
  min.cutoff = 0,
  max.cutoff = NA,
  common.scale = TRUE,
  flip.coords = FALSE
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Vector of features to plot. Features can come from:
\itemize{
    \item An \code{Assay} feature (e.g. a gene name - "MS4A1")
    \item A column name from meta.data (e.g. mitochondrial percentage - "percent.mito")
    \item A column name from a \code{DimReduc} object corresponding to the cell embedding values
    (e.g. the PC 1 scores - "PC_1")
}}

\item{cells}{Vector of cells to plot (default is all cells)}

\item{poly.data}{Name of the polygon dataframe in the misc slot}

\item{ncol}{Number of columns to split the plot into}

\item{min.cutoff}{Vector of minimum and maximum cutoff values for each feature,
may specify quantile in the form of 'q##' where '##' is the quantile (eg, 'q1', 'q10')}

\item{max.cutoff}{Vector of minimum and maximum cutoff values for each feature,
may specify quantile in the form of 'q##' where '##' is the quantile (eg, 'q1', 'q10')}

\item{common.scale}{...}

\item{flip.coords}{Flip x and y coordinates}
}
\value{
Returns a ggplot object
}
\description{
Plot cells as polygons, rather than single points. Color cells by any value accessible by \code{\link{FetchData}}.
}
\concept{visualization}
