% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{LinkedPlots}
\alias{LinkedPlots}
\alias{LinkedDimPlot}
\alias{LinkedPlot}
\alias{LinkedFeaturePlot}
\title{Visualize spatial and clustering (dimensional reduction) data in a linked,
interactive framework}
\usage{
LinkedDimPlot(
  object,
  dims = 1:2,
  reduction = NULL,
  image = NULL,
  group.by = NULL,
  alpha = c(0.1, 1),
  combine = TRUE
)

LinkedFeaturePlot(
  object,
  feature,
  dims = 1:2,
  reduction = NULL,
  image = NULL,
  slot = "data",
  alpha = c(0.1, 1),
  combine = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{reduction}{Which dimensionality reduction to use. If not specified, first searches for umap, then tsne, then pca}

\item{image}{Name of the image to use in the plot}

\item{group.by}{Name of one or more metadata columns to group (color) cells by
(for example, orig.ident); pass 'ident' to group by identity class}

\item{alpha}{Controls opacity of spots. Provide as a vector specifying the
min and max for SpatialFeaturePlot. For SpatialDimPlot, provide a single
alpha value for each plot.}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}
ggplot object. If \code{FALSE}, return a list of ggplot objects}

\item{feature}{Feature to visualize}

\item{slot}{Which slot to pull expression data from?}
}
\value{
Returns final plots. If \code{combine}, plots are stiched together
using \code{\link{CombinePlots}}; otherwise, returns a list of ggplot objects
}
\description{
Visualize spatial and clustering (dimensional reduction) data in a linked,
interactive framework
}
\examples{
\dontrun{
LinkedDimPlot(seurat.object)
LinkedFeaturePlot(seurat.object, feature = 'Hpca')
}

}
\concept{spatial}
\concept{visualization}
