% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr.r
\name{reannualize}
\alias{reannualize}
\alias{reannualize.sr}
\alias{reannualize.sropt}
\title{Change the annualization of a Sharpe ratio.}
\usage{
reannualize(object, new.ope = NULL, new.epoch = NULL)

\method{reannualize}{sr}(object, new.ope = NULL, new.epoch = NULL)

\method{reannualize}{sropt}(object, new.ope = NULL, new.epoch = NULL)
}
\arguments{
\item{object}{an object of class \code{sr} or \code{sropt}.}

\item{new.ope}{the new observations per epoch. If none given, it is
not updated.}

\item{new.epoch}{a string representation of the epoch. If none given, it is not
updated.}
}
\value{
the input object with the annualization and/or epoch updated.
}
\description{
Changes the annualization factor of a Sharpe ratio statistic, or the rate at
which observations are made.
}
\examples{
# compute a 'daily' Sharpe
mysr <- as.sr(rnorm(253*8),ope=1,epoch="day")
# turn into annual 
mysr2 <- reannualize(mysr,new.ope=253,new.epoch="yr")

# for sropt
ope <- 253
zeta.s <- 1.0  
df1 <- 10
df2 <- 6 * ope
rvs <- rsropt(1,df1,df2,zeta.s,ope,drag=0)
roll.own <- sropt(z.s=rvs,df1,df2,drag=0,ope=ope,epoch="yr")
# make 'monthly'
roll.monthly <- reannualize(roll.own,new.ope=21,new.epoch="mo.")
# make 'daily'
roll.daily <- reannualize(roll.own,new.ope=1,new.epoch="day")
}
\seealso{
sr

sropt

Other sr: \code{\link{as.sr}}, \code{\link{confint.sr}},
  \code{\link{dsr}}, \code{\link{is.sr}},
  \code{\link{plambdap}}, \code{\link{power.sr_test}},
  \code{\link{predint}}, \code{\link{print.sr}},
  \code{\link{se}}, \code{\link{sr_equality_test}},
  \code{\link{sr_test}}, \code{\link{sr_unpaired_test}},
  \code{\link{sr_vcov}}, \code{\link{sr}},
  \code{\link{summary.sr}}

Other sropt: \code{\link{as.sropt}},
  \code{\link{confint.sr}}, \code{\link{dsropt}},
  \code{\link{is.sropt}}, \code{\link{pco_sropt}},
  \code{\link{power.sropt_test}}, \code{\link{sropt_test}},
  \code{\link{sropt}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
