% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggWrightMap.R
\name{ggWrightMap}
\alias{ggWrightMap}
\title{Wright Map using ggplot}
\usage{
ggWrightMap(theta, b, binwidth = 0.5, color = "blue", size = 15, item.names)
}
\arguments{
\item{theta}{numeric: vector of ability estimates.}

\item{b}{numeric: vector of difficulty estimates.}

\item{binwidth}{numeric: the width of the bins of histogram.}

\item{color}{character: color of histogram.}

\item{size}{text size in pts.}

\item{item.names}{names of items to be displayed.}
}
\description{
This function allows to generate Wright Map (also called item-person map)
using \code{ggplot} function from package \code{ggplot2} and \code{plot_grid} function
from \code{cowplot}. Wright Map is used to display histogram
of factor scores and the item difficulty parameters estimated by the Rasch IRT model.
}
\examples{
library(mirt)

# loading 100-item medical admission test data sets
data(dataMedical)
# binary data set
dataBin <- dataMedical[, 1:100]

# fit Rasch model with mirt package
fit <- mirt(dataBin, model = 1, itemtype = "Rasch")
# factor scores
theta <- as.vector(fscores(fit))
# difficulty estimates
b <- coef(fit, simplify = TRUE)$items[, "d"]

ggWrightMap(theta, b)

item.names <- paste("Item", 1:20)
ggWrightMap(theta, b, item.names = item.names)
}
\references{
Wright, B. D., & Stone, M. H. (1979). Best test design.
}
\seealso{
\code{\link[WrightMap]{wrightMap}}
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
