% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startShinyItemAnalysis.R
\name{startShinyItemAnalysis}
\alias{startShinyItemAnalysis}
\alias{run_app}
\title{Start ShinyItemAnalysis application}
\usage{
startShinyItemAnalysis(background = TRUE, ...)

run_app(background = TRUE, ...)
}
\arguments{
\item{background}{\emph{logical}, should the application be run as a
background process (in the 'RStudio')?}

\item{...}{
  Arguments passed on to \code{\link[utils:install.packages]{utils::install.packages}}
  \describe{
    \item{\code{lib}}{
    character vector giving the library directories where to
    install the packages.  Recycled as needed.  If missing, defaults to
    the first element of \code{\link{.libPaths}()}.
  }
    \item{\code{repos}}{
    character vector, the base URL(s) of the repositories
    to use, e.g., the URL of a CRAN mirror such as
    \code{"https://cloud.r-project.org"}.  For more details on
    supported URL schemes see \code{\link{url}}.

    Can be \code{NULL} to install from local files, directories or URLs:
    this will be inferred by extension from \code{pkgs} if of length one.
  }
    \item{\code{contriburl}}{
    URL(s) of the contrib sections of the repositories.  Use this
    argument if your repository mirror is incomplete, e.g., because
    you mirrored only the \file{contrib} section, or only have
    binary packages.  Overrides argument \code{repos}.
    Incompatible with \code{type = "both"}.
  }
    \item{\code{method}}{
    download method, see \code{\link[utils]{download.file}}.  Unused if
    a non-\code{NULL} \code{available} is supplied.
  }
    \item{\code{available}}{
    a matrix as returned by \code{\link[utils]{available.packages}}
    listing packages available at the repositories, or \code{NULL} when
    the function makes an internal call to \code{available.packages}.
    Incompatible with \code{type = "both"}.
  }
    \item{\code{destdir}}{
    directory where downloaded packages are stored.  If it is
    \code{NULL} (the default) a subdirectory
    \code{downloaded_packages} of the session temporary
    directory will be used (and the files will be deleted
    at the end of the session).
  }
    \item{\code{dependencies}}{logical indicating whether to also install
    uninstalled packages which these packages depend on/link
    to/import/suggest (and so on recursively).
    Not used if \code{repos = NULL}.
    Can also be a character vector, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.

    Only supported if \code{lib} is of length one (or missing),
    so it is unambiguous where to install the dependent packages.  If
    this is not the case it is ignored, with a warning.

    The default, \code{NA}, means
    \code{c("Depends", "Imports", "LinkingTo")}.

    \code{TRUE} means to use
    \code{c("Depends", "Imports", "LinkingTo", "Suggests")} for
    \code{pkgs} and
    \code{c("Depends", "Imports", "LinkingTo")} for added dependencies:
    this installs all the packages needed to run \code{pkgs}, their
    examples, tests and vignettes (if the package author specified them
    correctly).

    In all of these, \code{"LinkingTo"} is omitted for binary packages.
  }
    \item{\code{type}}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }
    \item{\code{configure.args}}{
    (Used only for source installs.) A character vector or a named list.
    If a character vector with no names is supplied, the elements are
    concatenated into a single string (separated by a space) and used as
    the value for the \option{--configure-args} flag in the call to
    \command{R CMD INSTALL}.  If the character vector has names these
    are assumed to identify values for \option{--configure-args} for
    individual packages.  This allows one to specify settings for an
    entire collection of packages which will be used if any of those
    packages are to be installed.  (These settings can therefore be
    re-used and act as default settings.)

    A named list can be used also to the same effect, and that
    allows multi-element character strings for each package
    which are concatenated to a single string to be used as the
    value for \option{--configure-args}.
  }
    \item{\code{configure.vars}}{
    (Used only for source installs.) Analogous to \code{configure.args}
    for flag \option{--configure-vars}, which is used to set environment
    variables for the \command{configure} run.
  }
    \item{\code{clean}}{a logical value indicating whether to add the
    \option{--clean} flag to the call to \command{R CMD INSTALL}.
    This is sometimes used to perform additional operations at the end
    of the package installation in addition to removing intermediate files.
  }
    \item{\code{Ncpus}}{the number of parallel processes to use for a parallel
    install of more than one source package.  Values greater than one
    are supported if the \command{make} command specified by
    \code{Sys.getenv("MAKE", "make")} accepts argument
    \code{-k -j \var{Ncpus}}.
  }
    \item{\code{verbose}}{
    a logical indicating if some \dQuote{progress report} should be given.
  }
    \item{\code{INSTALL_opts}}{
    an optional character vector of additional option(s) to be passed to
    \command{R CMD INSTALL} for a source package install.  E.g.,
    \code{c("--html", "--no-multiarch", "--no-test-load")}.

    Can also be a named list of character vectors to be used as
    additional options, with names the respective package names.
  }
    \item{\code{quiet}}{
    logical: if true, reduce the amount of output.  This is \emph{not}
    passed to \code{\link[utils]{available.packages}()} in case that is called, on
    purpose.
  }
    \item{\code{keep_outputs}}{
    a logical: if true, keep the outputs from installing source packages
    in the current working directory, with the names of the output files
    the package names with \file{.out} appended.  Alternatively, a
    character string giving the directory in which to save the outputs.
    Ignored when installing from local files.
  }
  }}
}
\value{
No return value. Called for side effects.
}
\description{
An interactive shiny application to run test and item analysis. By default,
the function runs the application as a background process ("Jobs" tab in the
"RStudio" IDE). User is then free to use the \code{R} Console for other work
and to try the sample R code examples. You can still run the app the usual
way in the console by specifying \code{background = FALSE}.
}
\examples{
\dontrun{
startShinyItemAnalysis()
startShinyItemAnalysis(background = FALSE)
}

}
\author{
Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz}

Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{hladka@cs.cas.cz}

Jan Netik \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{netik@cs.cas.cz}
}
