% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{isTreeChild}
\alias{isTreeChild}
\title{Determine whether a network is tree-child}
\usage{
isTreeChild(net)
}
\arguments{
\item{net}{A phylogenetic network of class \code{evonet}.}
}
\value{
A logical that is \code{TRUE} if the network is tree-child
}
\description{
This function determines whether a network is tree-child
}
\details{
A phylogenetic network is said to be tree-child if all internal nodes have at least one tree-like or leaf node as children.
}
\examples{
net<- read.net(text= "((A:7,((B:2,C:2):3)#H1:2::0.6):3,(D:6,#H1:1::0.4):4);")
isTreeChild(net) ##returns TRUE
}
