% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{ExpressionPlot}
\alias{ExpressionPlot}
\title{Plot gene expression}
\usage{
ExpressionPlot(
  object,
  features,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  slot = "data"
)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{A list of features to plot}

\item{assay}{Name of the assay storing expression information}

\item{group.by}{A grouping variable to group cells by. If NULL, use the
current cell identities}

\item{idents}{A list of identities to include in the plot. If NULL, include
all identities}

\item{slot}{Which slot to pull expression data from}
}
\description{
Display gene expression values for different groups of cells and different
genes. Genes will be arranged on the x-axis and different groups stacked on
the y-axis, with expression value distribution for each group shown as a
violin plot. This is designed to work alongside a genomic coverage track,
and the plot will be able to be aligned with coverage tracks for the same
groups of cells.
}
\examples{
ExpressionPlot(atac_small, features = "TSPAN6", assay = "RNA")
}
\concept{visualization}
