% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{PlotFootprint}
\alias{PlotFootprint}
\title{Plot motif footprinting results}
\usage{
PlotFootprint(
  object,
  features,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  label = TRUE,
  repel = TRUE,
  show.expected = TRUE,
  normalization = "subtract",
  label.top = 3,
  label.idents = NULL
)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{A vector of features to plot}

\item{assay}{Name of assay to use}

\item{group.by}{A grouping variable}

\item{idents}{Set of identities to include in the plot}

\item{label}{TRUE/FALSE value to control whether groups are labelled.}

\item{repel}{Repel labels from each other}

\item{show.expected}{Plot the expected Tn5 integration frequency below the
main footprint plot}

\item{normalization}{Method to normalize for Tn5 DNA sequence bias. Options
are "subtract", "divide", or NULL to perform no bias correction.}

\item{label.top}{Number of groups to label based on highest accessibility
in motif flanking region.}

\item{label.idents}{Vector of identities to label. If supplied,
\code{label.top} will be ignored.}
}
\description{
Plot motif footprinting results
}
\concept{footprinting}
\concept{visualization}
