% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{FragmentHistogram}
\alias{FragmentHistogram}
\title{Plot fragment length histogram}
\usage{
FragmentHistogram(
  object,
  assay = NULL,
  region = "chr1-1-2000000",
  group.by = NULL,
  cells = NULL,
  log.scale = FALSE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Which assay to use. Default is the active assay.}

\item{region}{Genomic range to use. Default is fist two megabases of
chromosome 1. Can be a GRanges object, a string, or a vector
of strings.}

\item{group.by}{Name of one or more metadata columns to group (color) the
cells by. Default is the current cell identities}

\item{cells}{Which cells to plot. Default all cells}

\item{log.scale}{Display Y-axis on log scale. Default is FALSE.}

\item{...}{Arguments passed to other functions}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot the frequency that fragments of different lengths are present for
different groups of cells.
}
\examples{
\donttest{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
Fragments(atac_small) <- CreateFragmentObject(
  path = fpath,
  cells = colnames(atac_small),
  validate.fragments = FALSE
)
FragmentHistogram(object = atac_small, region = "chr1-10245-780007")
}
}
\concept{qc}
\concept{visualization}
