% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{FindTopFeatures}
\alias{FindTopFeatures}
\alias{FindTopFeatures.default}
\alias{FindTopFeatures.Assay}
\alias{FindTopFeatures.StdAssay}
\alias{FindTopFeatures.Seurat}
\title{Find most frequently observed features}
\usage{
FindTopFeatures(object, ...)

\method{FindTopFeatures}{default}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)

\method{FindTopFeatures}{Assay}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)

\method{FindTopFeatures}{StdAssay}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)

\method{FindTopFeatures}{Seurat}(object, assay = NULL, min.cutoff = "q5", verbose = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{assay}{Name of assay to use}

\item{min.cutoff}{Cutoff for feature to be included in the VariableFeatures
for the object. This can be a percentile specified as 'q' followed by the
minimum percentile, for example 'q5' to set the top 95\% most common features
as the VariableFeatures for the object. Alternatively, this can be an integer
specifying the minimum number of counts for the feature
to be included in the set of VariableFeatures. For example, setting to 10
will include features with >10 total counts in the set of VariableFeatures. If NULL,
include all features in VariableFeatures. If NA, VariableFeatures will not be
altered, and only the feature metadata will be updated with the total counts
and percentile rank for each feature.}

\item{verbose}{Display messages}
}
\value{
Returns a \code{\link[SeuratObject]{Seurat}} object
}
\description{
Find top features for a given assay based on total number of counts for the
feature. Can specify a minimum cell count, or a lower percentile
bound to determine the set of variable features. Running this function will
store the total counts and percentile rank for each feature in the feature
metadata for the assay. To only compute the feature metadata, without
changing the variable features for the assay, set \code{min.cutoff=NA}.
}
\examples{
FindTopFeatures(object = atac_small[['peaks']]['data'])
FindTopFeatures(object = atac_small[['peaks']])
FindTopFeatures(object = atac_small[['peaks']])
FindTopFeatures(atac_small)
}
\concept{preprocessing}
