% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragments.R
\name{CreateFragmentObject}
\alias{CreateFragmentObject}
\title{Create a Fragment object}
\usage{
CreateFragmentObject(
  path,
  cells = NULL,
  validate.fragments = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{path}{A path to the fragment file. The file should contain a tabix
index in the same directory.}

\item{cells}{A named character vector containing cell barcodes contained in
the fragment file. This does not need to be all cells in the fragment file,
but there should be no cells in the vector that are not present in the
fragment file. A search of the file will be performed until at least one
fragment from each cell is found. If NULL, don't check for expected cells.

Each element of the vector should be a cell barcode that appears in the
fragment file, and the name of each element should be the corresponding cell
name in the object.}

\item{validate.fragments}{Check that expected cells are present in the
fragment file.}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{ValidateCells}}
}
\description{
Create a \code{Fragment} object to store fragment file information.
This object stores a 32-bit MD5 hash of the fragment file and the fragment
file index so that any changes to the files on-disk can be detected. A check
is also performed to ensure that the expected cells are present in the
fragment file.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
cells <- colnames(x = atac_small)
names(x = cells) <- paste0("test_", cells)
frags <- CreateFragmentObject(path = fpath, cells = cells, verbose = FALSE, tolerance = 0.5)
}
\concept{fragments}
