% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimension_reduction.R
\name{RunSVD}
\alias{RunSVD}
\alias{RunSVD.default}
\alias{RunSVD.Assay}
\alias{RunSVD.Seurat}
\title{Run singular value decomposition}
\usage{
RunSVD(object, ...)

\method{RunSVD}{default}(
  object,
  assay = NULL,
  n = 50,
  scale.embeddings = TRUE,
  reduction.key = "LSI_",
  scale.max = NULL,
  verbose = TRUE,
  irlba.work = n * 3,
  ...
)

\method{RunSVD}{Assay}(
  object,
  assay = NULL,
  features = NULL,
  n = 50,
  reduction.key = "LSI_",
  scale.max = NULL,
  verbose = TRUE,
  ...
)

\method{RunSVD}{Seurat}(
  object,
  assay = NULL,
  features = NULL,
  n = 50,
  reduction.key = "LSI_",
  reduction.name = "lsi",
  scale.max = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{assay}{Which assay to use. If NULL, use the default assay}

\item{n}{Number of singular values to compute}

\item{scale.embeddings}{Scale cell embeddings within each component to
mean 0 and SD 1 (default TRUE).}

\item{reduction.key}{Key for dimension reduction object}

\item{scale.max}{Clipping value for cell embeddings.
Default (NULL) is no clipping.}

\item{verbose}{Print messages}

\item{irlba.work}{work parameter for \code{\link[irlba]{irlba}}.
Working subspace dimension, larger values can speed convergence at the
cost of more memory use.}

\item{features}{Which features to use. If NULL, use variable features}

\item{reduction.name}{Name for stored dimension reduction object.
Default 'svd'}
}
\value{
Returns a \code{\link[SeuratObject]{Seurat}} object
}
\description{
Run partial singular value decomposition using \code{\link[irlba]{irlba}}
}
\examples{
x <- matrix(data = rnorm(100), ncol = 10)
RunSVD(x)
RunSVD(atac_small[['peaks']])
RunSVD(atac_small)
}
\concept{dimension_reduction}
