% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{VariantPlot}
\alias{VariantPlot}
\title{Plot strand concordance vs. VMR}
\usage{
VariantPlot(
  variants,
  min.cells = 2,
  concordance.threshold = 0.65,
  vmr.threshold = 0.01
)
}
\arguments{
\item{variants}{A dataframe containing variant information. This should be
computed using \code{\link{IdentifyVariants}}}

\item{min.cells}{Minimum number of high-confidence cells detected with the
variant for the variant to be displayed.}

\item{concordance.threshold}{Strand concordance threshold}

\item{vmr.threshold}{Mean-variance ratio threshold}
}
\description{
Plot the Pearson correlation between allele frequencies on each strand
versus the log10 mean-variance ratio for the allele.
}
\concept{mito}
\concept{visualization}
