% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragments.R
\name{CountFragments}
\alias{CountFragments}
\title{Count fragments}
\usage{
CountFragments(fragments, cells = NULL, max_lines = NULL, verbose = TRUE)
}
\arguments{
\item{fragments}{Path to a fragment file. If a list of fragment files is
provided, the total fragments for each cell barcode across all files will be
returned}

\item{cells}{Cells to include. If NULL, include all cells}

\item{max_lines}{Maximum number of lines to read from the fragment file. If
NULL, read all lines in the file.}

\item{verbose}{Display messages}
}
\value{
Returns a data.frame with the following columns:
\itemize{
  \item{CB: the cell barcode}
  \item{frequency_count: total number of fragments sequenced for the cell}
  \item{mononucleosome: total number of fragments with length between 147 bp and 294 bp}
  \item{nucleosome_free: total number of fragments with length <147 bp}
  \item{reads_count: total number of reads sequenced for the cell}
}
}
\description{
Count total fragments per cell barcode present in a fragment file.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
counts <- CountFragments(fragments = fpath)
}
\concept{fragments}
