% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.CopApprox}
\alias{plot.CopApprox}
\title{Plot the histogram density approximation to a copula}
\usage{
\method{plot}{CopApprox}(x, ...)
}
\arguments{
\item{x}{an object of \code{\link{class}} \sQuote{CopApprox}.}

\item{\dots}{not used.}
}
\description{
Plots the histogram density approximation to a copula as determined by \code{\link{GetApprox}}.  Currently works only for bivariate copulae.
}
\examples{
Cop <- NewMEVGumbelCopula(4)
CopApprox1 <- GetApprox(Cop, dim=2)
plot(CopApprox1)
CopApprox2 <- GetApprox(Cop, dim=2, type=2)
plot(CopApprox2)

}
\references{
Tajvidi, N. and Turlach, B.A. (2017). A general approach to generate random variates for multivariate copulae, \emph{Australian & New Zealand Journal of Statistics}. Doi:10.1111/anzs.12209.
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{hplot}
