% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_simpdf_theory.R
\name{plot_simpdf_theory}
\alias{plot_simpdf_theory}
\title{Plot Simulated Probability Density Function and Target PDF by Distribution Name or Function for Continuous or Count Variables}
\usage{
plot_simpdf_theory(sim_y, title = "Simulated Probability Density Function",
  ylower = NULL, yupper = NULL, sim_color = "dark blue", sim_lty = 1,
  sim_size = 1, col_width = 0.5, overlay = TRUE, cont_var = TRUE,
  target_color = "dark green", target_lty = 2, target_size = 1,
  Dist = c("Benini", "Beta", "Beta-Normal", "Birnbaum-Saunders", "Chisq",
  "Dagum", "Exponential", "Exp-Geometric", "Exp-Logarithmic", "Exp-Poisson",
  "F", "Fisk", "Frechet", "Gamma", "Gaussian", "Gompertz", "Gumbel",
  "Kumaraswamy", "Laplace", "Lindley", "Logistic", "Loggamma", "Lognormal",
  "Lomax", "Makeham", "Maxwell", "Nakagami", "Paralogistic", "Pareto", "Perks",
  "Rayleigh", "Rice", "Singh-Maddala", "Skewnormal", "t", "Topp-Leone",
  "Triangular", "Uniform", "Weibull", "Poisson", "Negative_Binomial"),
  params = NULL, fx = NULL, lower = NULL, upper = NULL,
  legend.position = c(0.975, 0.9), legend.justification = c(1, 1),
  legend.text.size = 10, title.text.size = 15, axis.text.size = 10,
  axis.title.size = 13)
}
\arguments{
\item{sim_y}{a vector of simulated data}

\item{title}{the title for the graph (default = "Simulated Probability Density Function")}

\item{ylower}{the lower y value to use in the plot (default = NULL, uses minimum simulated y value) on the x-axis}

\item{yupper}{the upper y value (default = NULL, uses maximum simulated y value) on the x-axis}

\item{sim_color}{the line color for the simulated PDF (or column fill color in the case of
\code{Dist} = "Poisson" or "Negative_Binomial")}

\item{sim_lty}{the line type for the simulated PDF (default = 1, solid line)}

\item{sim_size}{the line width for the simulated PDF}

\item{col_width}{width of column for simulated/target PMF of count variables (default = 0.5)}

\item{overlay}{if TRUE (default), the target distribution is also plotted given either a distribution name (and parameters)
or PDF function fx (with bounds = ylower, yupper)}

\item{cont_var}{TRUE (default) for continuous variables, FALSE for count variables}

\item{target_color}{the line color for the target PDF (or column fill color in the case of
\code{Dist} = "Poisson" or "Negative_Binomial")}

\item{target_lty}{the line type for the target PDF (default = 2, dashed line)}

\item{target_size}{the line width for the target PDF}

\item{Dist}{name of the distribution. The possible values are: "Benini", "Beta", "Beta-Normal", "Birnbaum-Saunders", "Chisq",
"Exponential", "Exp-Geometric", "Exp-Logarithmic", "Exp-Poisson", "F", "Fisk", "Frechet", "Gamma", "Gaussian", "Gompertz",
"Gumbel", "Kumaraswamy", "Laplace", "Lindley", "Logistic", \cr"Loggamma", "Lognormal", "Lomax", "Makeham", "Maxwell",
"Nakagami", "Paralogistic", "Pareto", "Perks", "Rayleigh", "Rice", "Singh-Maddala", \cr"Skewnormal", "t", "Topp-Leone", "Triangular",
"Uniform", "Weibull", "Poisson", and "Negative_Binomial".
Please refer to the documentation for each package (either \code{\link[stats]{stats-package}}, \code{\link[VGAM]{VGAM-package}}, or
\code{\link[triangle]{triangle}}) for information on appropriate parameter inputs.}

\item{params}{a vector of parameters (up to 4) for the desired distribution (keep NULL if \code{fx} supplied instead); for
Poisson variables, must be lambda (mean) and the probability of a structural zero (use 0 for regular Poisson variables); for
Negative Binomial variables, must be size, mean and the probability of a structural zero (use 0 for regular NB variables)}

\item{fx}{a PDF input as a function of x only, i.e. \code{fx = function(x) 0.5 * (x - 1)^2}; must return a scalar
(keep NULL if \code{Dist} supplied instead)}

\item{lower}{the lower support bound for \code{fx}}

\item{upper}{the upper support bound for \code{fx}}

\item{legend.position}{the position of the legend}

\item{legend.justification}{the justification of the legend}

\item{legend.text.size}{the size of the legend labels}

\item{title.text.size}{the size of the plot title}

\item{axis.text.size}{the size of the axes text (tick labels)}

\item{axis.title.size}{the size of the axes titles}
}
\value{
A \code{\link[ggplot2]{ggplot2-package}} object.
}
\description{
This plots the PDF of simulated continuous or count (regular or zero-inflated, Poisson or Negative Binomial) data and
    overlays the target PDF (if \code{overlay} = TRUE), which is specified by distribution name (plus up to 4 parameters) or PDF
    function \code{fx} (plus support bounds).  If a continuous target distribution is provided (\code{cont_var = TRUE}), the simulated
    data \eqn{y} is scaled and then transformed (i.e. \eqn{y = sigma * scale(y) + mu}) so that it has the same mean (\eqn{mu}) and
    variance (\eqn{sigma^2}) as the target distribution.  The PDF's of continuous variables are shown as lines (using
    \code{\link[ggplot2]{geom_density}} and \code{ggplot2::geom_line}).  It works for valid or invalid power method PDF's.
    The PMF's of count variables are shown as vertical bar graphs (using \code{ggplot2::geom_col}).  The function returns a
    \code{\link[ggplot2]{ggplot2-package}} object so the user can save it or modify it as necessary.  The graph parameters
    (i.e. \code{title}, \code{sim_color}, \code{sim_lty}, \code{sim_size}, \code{target_color}, \code{target_lty}, \code{target_size},
    \code{legend.position}, \code{legend.justification}, \code{legend.text.size}, \code{title.text.size},
    \code{axis.text.size}, and \code{axis.title.size}) are inputs to the \code{\link[ggplot2]{ggplot2-package}} functions so information about
    valid inputs can be obtained from that package's documentation.
}
\examples{
# Using normal mixture variable from contmixvar1 example
Nmix <- contmixvar1(n = 1000, "Polynomial", means = 0, vars = 1,
  mix_pis = c(0.4, 0.6), mix_mus = c(-2, 2), mix_sigmas = c(1, 1),
  mix_skews = c(0, 0), mix_skurts = c(0, 0), mix_fifths = c(0, 0),
  mix_sixths = c(0, 0))
plot_simpdf_theory(Nmix$Y_mix[, 1],
  title = "Mixture of Normal Distributions",
  fx = function(x) 0.4 * dnorm(x, -2, 1) + 0.6 * dnorm(x, 2, 1),
  lower = -5, upper = 5)
\dontrun{
# Mixture of Beta(6, 3), Beta(4, 1.5), and Beta(10, 20)
Stcum1 <- calc_theory("Beta", c(6, 3))
Stcum2 <- calc_theory("Beta", c(4, 1.5))
Stcum3 <- calc_theory("Beta", c(10, 20))
mix_pis <- c(0.5, 0.2, 0.3)
mix_mus <- c(Stcum1[1], Stcum2[1], Stcum3[1])
mix_sigmas <- c(Stcum1[2], Stcum2[2], Stcum3[2])
mix_skews <- c(Stcum1[3], Stcum2[3], Stcum3[3])
mix_skurts <- c(Stcum1[4], Stcum2[4], Stcum3[4])
mix_fifths <- c(Stcum1[5], Stcum2[5], Stcum3[5])
mix_sixths <- c(Stcum1[6], Stcum2[6], Stcum3[6])
mix_Six <- list(seq(0.01, 10, 0.01), c(0.01, 0.02, 0.03),
  seq(0.01, 10, 0.01))
Bstcum <- calc_mixmoments(mix_pis, mix_mus, mix_sigmas, mix_skews,
  mix_skurts, mix_fifths, mix_sixths)
Bmix <- contmixvar1(n = 10000, "Polynomial", Bstcum[1], Bstcum[2]^2,
  mix_pis, mix_mus, mix_sigmas, mix_skews, mix_skurts, mix_fifths,
  mix_sixths, mix_Six)
plot_simpdf_theory(Bmix$Y_mix[, 1], title = "Mixture of Beta Distributions",
  fx = function(x) mix_pis[1] * dbeta(x, 6, 3) + mix_pis[2] *
    dbeta(x, 4, 1.5) + mix_pis[3] * dbeta(x, 10, 20), lower = 0, upper = 1)
}

}
\references{
Please see the references for \code{\link[SimCorrMix]{plot_simtheory}}.
}
\seealso{
\code{\link[SimMultiCorrData]{calc_theory}}, \code{\link[ggplot2]{ggplot}}
}
\keyword{plot}
