% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimDesign_functions.R
\name{SimDesign_functions}
\alias{SimDesign_functions}
\title{Skeleton functions for simulations}
\usage{
SimDesign_functions(filename = NULL, comments = TRUE, singlefile = FALSE)
}
\arguments{
\item{filename}{a character vector indicating whether the output should be saved to two respective files
containing the simulation design and the functional components, respectively. Using this option
is generally the recommended approach when beginning to write a Monte Carlo simulation}

\item{comments}{logical; include helpful comments? Default is \code{TRUE}}

\item{singlefile}{logical; when \code{filename} is included, put output in one files? When \code{FALSE} the
output is saved to two separate files containing the functions and design definitions. Default is
\code{FALSE}}
}
\description{
This function prints skeleton versions of the required functions and work-flow required
to run simulations, complete with the correct inputs and class of outputs. Use this at the start
when defining your simulation.
}
\examples{

SimDesign_functions()
SimDesign_functions(comments=FALSE) #without comments

\dontrun{

# write output to two files
SimDesign_functions('mysim')

# write output files to a single file without comments
SimDesign_functions('mysim', comments = FALSE, singlefile = TRUE)
}

}

