% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apparent.activities.Aq.R
\name{apparent.activities.Aq}
\alias{apparent.activities.Aq}
\title{Apparent activity computation}
\usage{
apparent.activities.Aq(phi_q,A_fun,B_fun,correl_fun,eiq_eff=NULL)
}
\arguments{
\item{phi_q}{Numeric vector containing the numbers of enzymes in the group (ideally, element of the list returns by \code{\link{class_group}})}

\item{A_fun}{Numeric vector of activities}

\item{B_fun}{Numeric vector of global co-regulation coefficients. Same length as \code{E_ini_fun}.}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{eiq_eff}{Numeric vector of the intra-group relative concentrations at effective equilibrium.}
}
\value{
Numeric value of the apparent activity of chosen group.
}
\description{
Computes the group apparent pseudo-activities at equilibrium
}
\details{
Computes the apparent pseudo-activities of regulation groups at theoretical equilibrium (no competition) or effective equilibrium (competition).
 
When there is competition, \code{eiq_eff} is needed.

If there is only one regulation group (all enzymes are co-regulated), apparent activity of the group is not useful.
When the enzyme is in a singleton (enzyme independent from all other enzymes), the apparent activity of the group is identical to the activity of the enzyme.

    
In other functions, pseudo-activity is also named activity.
}
\examples{
#Two groups
n <- 3
A <- c(1,10,30)
beta <- diag(1,n) 
beta[1,2] <- -0.32 
beta[2,1] <- 1/beta[1,2]
B <- compute.B.from.beta(beta)

L_Phi <- class_group(beta)

correl <- "RegNeg"
#apply function of all groups
A_app <- unlist(lapply(L_Phi,apparent.activities.Aq,A,B,correl)) 

}
\seealso{
Function \code{\link{class_group}} to classify enzymes in groups.
}
