% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censoring_random.R
\name{random_censoring_exp}
\alias{random_censoring_exp}
\title{Apply Random Exponentially Distributed Censoring}
\usage{
random_censoring_exp(dat, rate, discrete = TRUE)
}
\arguments{
\item{dat}{the dataset to apply the random censoring to}

\item{rate}{time of end of enrollment}

\item{discrete}{should the censoring times be rounded to whole days?}
}
\value{
Returns a Function with one argument \code{dat} that modifies a dataset generated
by the generate functions by censoring the times and setting the event
indicator to \code{FALSE} for censored observations.
}
\description{
Apply Random Exponentially Distributed Censoring
}
\examples{

one_simulation <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by=NULL
) |>
  head(1) |>
  generate_delayed_effect()

# apply censoring to dataset
censored_sim <- random_censoring_exp(one_simulation, 0.01)

# plot
# uncensored (blue) observations are the same for original and modified
# dataset
# censored (red) observations are smaller than the uncensored ones
plot(
  one_simulation$t,
  censored_sim$t,
  col=ifelse(censored_sim$evt, "blue", "red"),
  xlab = "uncensored times",
  ylab = "censored times"
)
abline(0,1)
}
