% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise_estimator}
\alias{summarise_estimator}
\title{Generic Summarise function for esitmators}
\usage{
summarise_estimator(
  est,
  real,
  lower = NULL,
  upper = NULL,
  null = NULL,
  est_sd = NULL,
  name = NULL
)
}
\arguments{
\item{est}{estimator, expression evaluated in results}

\item{real}{real summary statistic, expression evaluated in condition}

\item{lower}{lower CI, expression evaluated in results}

\item{upper}{upper CI, expression evaluated in results}

\item{null}{parameter value under the null hypothesis}

\item{est_sd}{standard deviation estimated by the method, evaluated in results}

\item{name}{name for the summarise function,
appended to the name of the analysis method in the final results}
}
\value{
A function that can be used in Summarise that returns a data frame with
summary statistics of the performance measures in the columns.
}
\description{
Generic Summarise function for esitmators
}
\details{
The different parameters are evaluated in different envionments, \code{est},
\code{lower}, \code{upper}, \code{est_sd} refer to output of the method and are evaluated in
the results dataset. \code{real} refers to a real value of a summary statistic in
this scenario and is therefore evaluated in the condition dataset. \code{null} and
\code{name} are constants and directly evaluated when the function is defined.
The argument \code{null}, the parameter value under the null hypothesis is used to
output the rejection rate based on the confidence intervall. Which is output
in the column \code{null_cover}
}
\examples{
\donttest{
# generate the design matrix and append the true summary statistics
condition <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by=NULL
) |>
  tail(4) |>
  head(1) |>
  true_summary_statistics_delayed_effect(cutoff_stats = 15)

# create some summarise functions
summarise_all <- create_summarise_function(
  coxph=summarise_estimator(hr, gAHR_15, hr_lower, hr_upper, name="gAHR"),
  coxph=summarise_estimator(hr, hazard_trt/hazard_ctrl, hr_lower, hr_upper, name="HR"),
  coxph=summarise_estimator(hr, NA_real_, name="NA")
)

# runs simulations
sim_results <- runSimulation(
  design=condition,
  replications=10,
  generate=generate_delayed_effect,
  analyse=list(
    coxph=analyse_coxph()
  ),
  summarise = summarise_all
)

# mse is missing for the summarise function in which the real value was NA
sim_results[, names(sim_results) |> grepl(pattern="\\\\.mse$")]
# but the standard deviation can be estimated in all cases
sim_results[, names(sim_results) |> grepl(pattern="\\\\.sd_est$")]
}
}
