% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_process.R
\name{post_process}
\alias{post_process}
\title{Postprocessing of adapted solar irradiance}
\usage{
post_process(
  df_daytime,
  subset_target_period_high_elev,
  GHI_threshold,
  DNI_threshold
)
}
\arguments{
\item{df_daytime}{Dataframe object with daytime adapted solar radiation series including time (with same time zone as subset_target_period_high_elev)}

\item{subset_target_period_high_elev}{Dataframe object with daytime modeled solar radiation series including time (with same time zone as df_daytime)}

\item{GHI_threshold}{GHI threshold value, in the same units that modeled and adapted datasets. Default value is -99}

\item{DNI_threshold}{GHI threshold value, in the same units that modeled and adapted datasets. Default value is -99}
}
\value{
Dataframe object including time and site adapted solar irradiance series without inconsistencies
}
\description{
Postprocessing of adapted solar irradiance
}
\references{
Fernández-Peruchena, C.M.; Polo, J.; Martín, L.; Mazorra, L. Site-Adaptation of Modeled Solar Radiation Data: The SiteAdapt Procedure. Remote Sens. 2020, 12, 2127.
}
