% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcr.profiles.R
\name{outProfiles}
\alias{outProfiles}
\title{Get out-of-control profiles}
\usage{
outProfiles(profiles, x = 1:nrow(profiles), cLimits, tol = 0.5)
}
\arguments{
\item{profiles}{Matrix of profiles}

\item{x}{Vector with the independent variable}

\item{cLimits}{Matrix with the prototype and confidence bands profiles}

\item{tol}{Tolerance (\%)}
}
\value{
a list with the following elements:
\item{labOut}{labels of the out-of-control profiles}
\item{idOut}{ids of the out-of-control profiles}
\item{pOut}{proportion of times the profile values are out of the limits}
}
\description{
Returns a list with information about the out-of-control 
profiles given a set of profiles and some control limits
}
\examples{
wby.phase1 <- ss.data.wby[, 1:35]
wb.limits <- climProfiles(profiles = wby.phase1,
    x = ss.data.wbx,
    smoothprof = TRUE,
    smoothlim = TRUE)
wby.phase2 <- ss.data.wby[, 36:50]
wb.out.phase2 <- outProfiles(profiles = wby.phase2,
    x = ss.data.wbx,
    cLimits = wb.limits,
    tol = 0.8)
wb.out.phase2
plotProfiles(wby.phase2,
    x = ss.data.wbx,
    cLimits = wb.limits,
    outControl = wb.out.phase2$idOut,
    onlyout = TRUE)
}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}

