% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_annotation_Seurat.R
\name{Celltype_annotation_Seurat}
\alias{Celltype_annotation_Seurat}
\title{Uses "marker_list" from Seurat object for cell annotation}
\usage{
Celltype_annotation_Seurat(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  save_path = NULL,
  metric_names = NULL
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{Enter the standard "Marker_list" generated by the Seurat object
database for the SlimR package, generated by the "read_seurat_markers()"
function.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
"seurat_clusters"".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = "RNA"".}

\item{save_path}{The output path of the cell annotation picture. Default parameters
use "save_path = "./SlimR/Celltype_annotation_Seurat/"".}

\item{metric_names}{Warning: Do not enter information. This parameter is used to
check if "Marker_list" conforms to the Seurat object output.}
}
\value{
The cell annotation picture is saved in "save_path".
}
\description{
Uses "marker_list" from Seurat object for cell annotation
}
\examples{
\dontrun{Celltype_annotation_Seurat(seurat_obj = sce,
         gene_list = Markers_list_Seurat,
         species = "Human",
         cluster_col = "seurat_clusters",
         assay = "RNA",
         save_path = file.path(tempdir(),"SlimR_Celltype_annotation_Seurat")
         )
         }

}
