% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmCCNet-source.R
\name{getRobustWeightsSingleBinary}
\alias{getRobustWeightsSingleBinary}
\title{Single-omics SmCCA with Binary Phenotype}
\usage{
getRobustWeightsSingleBinary(
  X1,
  Trait,
  Lambda1,
  s1 = 0.7,
  SubsamplingNum = 1000,
  K = 3
)
}
\arguments{
\item{X1}{An \eqn{n\times p_1} data matrix (e.g. mRNA) with \eqn{p_1}
features and \eqn{n} subjects.}

\item{Trait}{An \eqn{n\times 1} trait (phenotype) data matrix for the same \eqn{n} subjects.}

\item{Lambda1}{LASSO penalty parameter for \code{X1}. \code{Lambda1} needs
to be between 0 and 1.}

\item{s1}{Proportion of mRNA features to be included, default at \code{s1 =
0.7}. \code{s1} needs to be between 0 and 1, default is set to 0.7.}

\item{SubsamplingNum}{Number of feature subsamples. Default is 1000. Larger
number leads to more accurate results, but at a higher computational cost.}

\item{K}{Number of hidden components for PLSDA, default is set to 3.}
}
\value{
A partial least squared weight matrix with \eqn{p_1} rows. Each
column is the canonical correlation weights based on subsampled \code{X1}
features. The number of columns is \code{SubsamplingNum}.
}
\description{
Compute aggregated (SmCCA) canonical weights for single omics data with quantitative phenotype (subampling enabled).
}
\examples{


X <- matrix(rnorm(600,0,1), nrow = 60)
Y <- rbinom(60,1,0.5)
Ws <- getRobustWeightsSingleBinary(X1 = X, Trait = as.matrix(Y), Lambda1 = 0.8, 
0.7, SubsamplingNum = 10)

}
