% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doCallParallel.R
\name{doCallParallel}
\alias{doCallParallel}
\title{Call a function with a vectorized input in parallel}
\usage{
doCallParallel(fun, x, ..., njobs = parallel::detectCores() - 1,
  random.seed = NULL)
}
\arguments{
\item{fun}{A function, or a text string with the name of the function, whose first argument is a vector and
returns a corresponding vector}

\item{x}{A vector of values that is the first argument to \code{fun}}

\item{njobs}{The number of parallel jobs to spawn using \code{\link{parLapplyW}}.}

\item{random.seed}{If a numeric value is provided, \code{x} is randomized to better distribute the work among
the jobs if some values of \code{x} take longer to evaluate than others.
The original ordering is restored before \code{fun(x, ...)} is returned. If \code{NULL},
no randomization is performed.}

\item{\dots}{Additional named arguments for \code{fun}}
}
\value{
The same result that would be had by calling \code{fun(x, ...)}, except calculated in parallel
}
\description{
Call a function with a vectorized input in parallel, where the function is computationally intensive.
}
\details{
This function is a parallelized wrapper for \code{\link{do.call}} designed for the case where \code{fun} is
computationally intensive.  Each element of \code{x} is evaluated
independently of the other elements of \code{x}.  Thus, \code{fun(c(x1,x2))} must be equivalent
to \code{c(fun(x1), fun(x2))} in order for \code{doCallParallel} to work properly.
}
\examples{
# Get a vector of x's
x <- rnorm(18, mean = 2, sd = 2)

# 2 cores
y1 <- doCallParallel("pnorm", x, mean = 2, sd = 2, njobs = 2)

# 2 cores and randomization
y2 <- doCallParallel(pnorm, x, mean = 2, sd = 2, njobs = 2, random.seed = 1)

# Without using doCallParallel()
y3 <- pnorm(x, mean = 2, sd = 2)

# Comparisons
identical(y1, y2)
identical(y1, y3)
}
\author{
Landon Sego
}

