% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comboList.R
\name{comboList}
\alias{comboList}
\title{Produces all possible combinations of a set of linear model predictors}
\usage{
comboList(n.pred, outFile = NULL, njobs = 1)
}
\arguments{
\item{n.pred}{integer indicating the number of predictors}

\item{outFile}{text string indicating the .Rdata file to which the returned
list of predictor combinations will be saved.  If NULL, then no file is
saved.}

\item{njobs}{Integer indicating the number of parallel jobs to be used in
calculating the combinations, using \code{\link{parLapplyW}}}
}
\value{
A list of class \code{combolist} is invisibly returned with the two
components shown below.  If \code{outFile} is not \code{NULL}, this same
list is saved to \code{outFile}: \item{len}{The total number of
combinations} \item{pList}{A list where each element contains an integer
representation of one combination of the predictors}
}
\description{
Produces a list representing all possible combinations of linear model
predictors
}
\details{
Uses \code{\link{combn}} to identify the combinations.
}
\examples{
x <- comboList(4)
print(x)

# A parallel job
y <- comboList(4, njobs = 2)

# Should be equal
identical(x, y)
}
\author{
Landon Sego
}
\keyword{misc}
