% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdsoftbart.R
\name{pdsoftbart}
\alias{pdsoftbart}
\title{Partial dependence plots for SoftBart}
\usage{
pdsoftbart(
  X,
  Y,
  xind = NULL,
  levs = NULL,
  levquants = c(0.05, (1:9)/10, 0.95),
  pl = FALSE,
  plquants = c(0.05, 0.95),
  ...
)
}
\arguments{
\item{X}{Training data covariates.}

\item{Y}{Training data response.}

\item{xind}{Variables to create the partial dependence plots for.}

\item{levs}{List of levels of the covariates to evaluate at.}

\item{levquants}{Used if \code{levs} is not supplied; takes \code{levs} to be quantiles of associated predictors.}

\item{pl}{Create a plot?}

\item{plquants}{Quantiles for the partial dependence plot.}

\item{...}{Additional arguments passed to softbart or plot.}
}
\value{
Returns a list with components given below. 

\itemize{
  \item \code{fd}: A matrix whose \code{(i,j)}th value is the \code{i}th draw of the partial dependence function for the 
            \code{j}th level.
 \item \code{levs}: The list of levels used, each component corresponding to a 
 variable. If the argument \code{levs} was supplied it is unchanged. Otherwise, the 
 levels in levs are constructed using the argument \code{levquants}.
}
}
\description{
Modified version of the \code{pdbart} function from the \code{BayesTree}
package; largely supplanted by the \code{softbart_regression} and
\code{partial_dependence_regression} functions. Runs \code{softbart} at test
observations constructed so that a plot can be created displaying the effect
of a single variable or pair of variables.
}
