% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_input.R
\name{N_input}
\alias{N_input}
\title{Estimate nitrogen input}
\usage{
N_input(var_MGMT_data, extended.output = FALSE)
}
\arguments{
\item{var_MGMT_data}{a \code{management_df} that contains the management information}

\item{extended.output}{an optional logical value:
\itemize{
\item If \code{FALSE}, N input values are aggregated by year
\item If \code{TRUE}, a tibble with all management operations is returned
\item Default value is \code{FALSE}
}}
}
\value{
by default, a tibble with N input values (organic N, mineral N and total N) by year is returned. If extended.output = TRUE, a tibble with daily resolution is returned.
}
\description{
This function estimates the nitrogen (N) input by mineral and organic
fertilization into the soil system per year.
}
\details{
The function takes a \code{management_df} as input and returns N input values
per year in the \code{management_df}.

Alternatively, it can return a extensive tibble with all management operations
and their N input values.

The functions calculates the N input by
organic fertilization with the \code{\link[=CN_input_amendments]{CN_input_amendments()}} function.
Furthermore, it calculates the livestock intensity (\code{LSU/ha}) by deviding
the animal derived N by \verb{105kgN/LSU}.

Be aware that the function currently neglects N that is fixated by plants (e.g. legumes)
}
\examples{
#example that returns annual N input values
N_input(EXAMPLE_data)

#example that returns a tibble with all management operations and their N input
N_input(EXAMPLE_data, extended.output = TRUE) 
}
\seealso{
\itemize{
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
\item \code{\link[=CN_input_amendments]{CN_input_amendments()}} for the calculation of N inputs from organic amendments
}
}
