% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant_cover.R
\name{plant_cover}
\alias{plant_cover}
\title{Estimate soil cover percentage by plants}
\usage{
plant_cover(varCrop, varDays = 0)
}
\arguments{
\item{varCrop}{Crop type, must match with crop name in \code{plant_cover_LUT}}

\item{varDays}{Number of days since sowing of the crop}
}
\value{
percentage of soil cover by plants, value of 0 to 100 \%.
}
\description{
This function estimates the percentage of soil cover
based on the number of days since sowing.
The parameters used are derived from \insertCite{mosimann2006;textual}{SoilManageR}.
}
\details{
The function assumes that plant cover unfolds in four phases with different soil cover rates:
\itemize{
\item 0 to 10 \% of soil cover
\item 10 to 50 \% of soil cover
\item 50 to 75 \% of soil cover
\item 75 to 100 \% of soil cover
}
}
\examples{
plant_cover("wheat, winter", 140)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=soil_cover]{soil_cover()}} to calculate soil coverage by plants and residue for a management_df
\item \code{\link[=plant_cover_LUT]{plant_cover_LUT()}} for the data used by the \code{\link[=plant_cover]{plant_cover()}} function
}
}
