% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addClass.R
\name{addClass}
\alias{addClass}
\title{Add a Class to an Object}
\usage{
addClass(x, class)
}
\arguments{
\item{x}{The object to receive new class(es).}

\item{class}{Character. The name of additional class(es).}
}
\value{
An object with new classes.
}
\description{
Utility to add (prepend) a class(es) to existing objects.
}
\examples{
class(iris)

addClass(iris, "new") |> class()

addClass(iris, c("A", "B")) |> class()    # 2 classes

addClass(iris, c("A", "data.frame")) |> class()    # no duplicates

addClass(iris, c("data.frame", "A")) |> class()    # re-orders if exists
}
\seealso{
\code{\link[=class]{class()}}, \code{\link[=typeof]{typeof()}}, \code{\link[=structure]{structure()}}
}
\author{
Stu Field
}
