% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeDspectro.R
\name{threeDspectro}
\alias{threeDspectro}
\title{3D spectrogram plots from \code{"Wave"} objects}
\usage{
threeDspectro(
  wave,
  tlim = NULL,
  flim = NULL,
  samp.grid = FALSE,
  plot.type = "surface",
  along = "x",
  skip.lines = 5,
  space.lines = 0.6,
  x.length = 100,
  y.length = 70,
  lwd = 0.1,
  plot.exp = FALSE,
  log.scale = FALSE,
  cex = 0.5,
  cex.axis = 0.5,
  cex.lab = 0.9,
  cex.main = 1,
  store.at = NULL,
  plot.as = "jpeg",
  color = seewave::spectro.colors(80),
  f = 44100,
  wl = 512,
  ovlp = 70,
  dBlevel = 30,
  resfac = 1,
  rotate.Xaxis = 60,
  rotate.Yaxis = 40,
  main = "Spectrogram 3D",
  scalelab = expression("Amplitude (dB)"),
  colkey = list(plot = TRUE, cex.clab = 0.8, cex.axis = 1, side = 4, length = 1, width =
    1, labels = TRUE, tick = TRUE, lty = 1, lwd = 1, lwd.ticks = 1)
)
}
\arguments{
\item{wave}{an \code{R} object of the class \code{"Wave"}}

\item{tlim}{modifications of the time limits (X-axis). Vector with two values in seconds. By default: \code{tlim = NULL}}

\item{flim}{modifications of the frequency limits (Y-axis). Vector with two values in kHz. By default: \code{flim = NULL}}

\item{samp.grid}{a logical. If \code{TRUE}, a sampling grid with dimensions \code{x.length} and \code{y.length} is applied over the three-dimensional surface. An amplitude value is collected at each node in the grid and a new matrix of amplitude coordinates is used in the plot. Recommended for faster plots and as protocol for error verification in point acquisition. See also \code{plot.type}. By default: \code{samp.grid = FALSE}}

\item{plot.type}{allows the choice between \code{"lines"}, \code{"surface"} or \code{"points"}. Beware that \code{"points"} only applies when \code{samp.grid = TRUE}. \code{plot.type = "surface"} will produce a simplified 3D spectrogram surface using the amplitude values colected by the sampling grid (same output employed by MacLeod et al., 2013). \code{plot.type = "points"} will produce 3D graphs with semilandmarks as points. \code{plot.type = "lines"} will generate profile lines along X or Y-axis (see argument \code{along}). Number and space between lines are controled by arguments \code{skip.lines} and \code{space.lines}, respectively. By default: \code{plot.type = "surface"}}

\item{along}{only applies when \code{plot.type = "lines"}. Lines along X or Y-axis (\code{"x"} or \code{"y"}). By default: \code{along = "x"}}

\item{skip.lines}{only applies when \code{plot.type = "lines"}. How many lines to skip between each plotted line. Larger numbers imply on less lines plotted. By default: \code{skip.lines = 5}}

\item{space.lines}{only applies when \code{plot.type = "lines"}. Controls the space between lines, which makes lines wider or narrower. Has to be a number between 0.1 and 0.9. By default: \code{space.lines = 0.6}}

\item{x.length}{only applies when \code{samp.grid = TRUE}. Length of sequence (i.e. number of cells per side on sound window) to be used as sampling grid coordinates on the time (X-axis).  By default: \code{x.length = 100}}

\item{y.length}{only applies when \code{samp.grid = TRUE}. Length of sequence (i.e. number of cells per side on sound window) to be used as sampling grid coordinates on the frequency (Y-axis). By default: \code{y.length = 70}}

\item{lwd}{only applies when \code{samp.grid = TRUE} and \code{plot.type = "surface"}. Similarly as in \code{\link{par}}, intended line width for sampling grid. By default: \code{lwd = 0.1}}

\item{plot.exp}{a logical. If \code{TRUE}, 3D spectrogram plot from \code{wave} object is exported and stored on the folder indicated by \code{store.at}. By default: \code{plot.exp = FALSE}}

\item{log.scale}{only applies when \code{samp.grid = TRUE}. A logical. If \code{TRUE}, \code{threeDspectro} will use a logarithmic scale on the time (X-axis), which is recommeded when the analyzed sounds present great variation on this axis (e.g. emphasize short duration sounds). If \code{FALSE}, a linear scale is used instead (same as MacLeod et al., 2013). By default: \code{log.scale = FALSE}}

\item{cex}{only applies when \code{samp.grid = TRUE} and \code{plot.type = "points"}. Similarly as in \code{\link{par}}, intended size for points. By default: \code{cex = 0.5}}

\item{cex.axis}{Similarly as in \code{\link{par}}, the magnification to be used for axis annotation. By default: \code{cex.axis = 0.5}}

\item{cex.lab}{Similarly as in \code{\link{par}}, the magnification to be used for x and y labels. By default: \code{cex.lab = 0.9}}

\item{cex.main}{Similarly as in \code{\link{par}}, the magnification to be used for main titles. By default: \code{cex.main = 1}}

\item{store.at}{only applies when \code{plot.exp = TRUE}. Filepath to the folder where 3D plot will be stored. Should be presented between quotation marks. By default: \code{store.at = NULL} (i.e. user must specify the filepath where spectrogram plots will be stored)}

\item{plot.as}{only applies when \code{plot.exp = TRUE}. \code{plot.as = "jpeg"} will generate compressed images for quick inspection; \code{plot.as = "tiff"} or \code{"tif"} will generate uncompressed high resolution images that can be edited and used for publication. By default: \code{plot.as = "jpeg"}}

\item{color}{Color palette to be used for the amplitude (Z-axis). Same default as \code{\link{spectro}}: \code{color=spectro.colors(80)}. See also \code{Details} section.}

\item{f}{sampling frequency of \code{Wave} object (in Hz). By default: \code{f = 44100}}

\item{wl}{length of the window for spectrogram calculation. By default: \code{wl = 512}}

\item{ovlp}{overlap between two successive windows (in \%) for increased spectrogram resolution. By default: \code{ovlp = 70}}

\item{dBlevel}{absolute amplitude value to be used as relative background on 3D plot. Same as \code{dBlevel} from \code{\link{eigensound}} and \code{\link{align.wave}}. By default: \code{dBlevel = 30}}

\item{resfac}{resolution factor, in which an value > 1 will increase the resolution. Can be one value or a vector of two numbers, for the x and y values, respectively. \strong{Note:} Same as in \code{\link{persp3D}} (\code{\link{plot3D}} package). By default: \code{resfac = 1}}

\item{rotate.Xaxis}{rotation of the X-axis. Same as \code{theta} from \code{\link{persp3D}} (\code{\link{plot3D}} package). By default: \code{rotate.Xaxis = 60}}

\item{rotate.Yaxis}{rotation of the Y-axis. Same as \code{phi} from \code{\link{persp3D}} (\code{\link{plot3D}} package). By default: \code{rotate.Yaxis = 40}}

\item{main}{main title of output plot. Should be presented between quotation marks. By default: \code{main = "3D spectrogram"}}

\item{scalelab}{Similarly as \code{\link{plot3D}}, the label to be written on top of the color key. Should be a character string wrapped by \code{expression()}. By default: \code{scalelab = expression("Amplitude (dB)")}. See also \code{\link{colkey}}}

\item{colkey}{Similarly as \code{\link{plot3D}}, a list with parameters for the color key (legend). By default: \code{colkey = list(plot = TRUE, cex.clab = 0.8, cex.axis = 1, side = 4, length = 1, width = 1, labels = TRUE, tick = TRUE, lty = 1, lwd = 1, lwd.ticks = 1)}. See also \code{\link{colkey}}}
}
\description{
Create 3D spectrograms from a single object of class \code{"Wave"}.

This function works similarly as \code{\link{spectro}} (\code{\link{seewave}} package), with spectrogram data internally computed by \code{\link{spectro}}. However, the 3D plot is generated by \code{\link{persp3D}} (\code{\link{plot3D}} package).
}
\details{
Similarly as \code{\link{spectro}} (\code{\link{seewave}} package), any colour palette can be used to describe the amplitude (Z-axis). Some suggestions: \code{seewave::temp.colors, seewave::spectro.colors, seewave::reverse.heat.colors, seewave::reverse.cm.colors, seewave::reverse.topo.colors, grDevices::cm.colors, grDevices::grey.colors, grDevices::heat.colors, grDevices::topo.colors}.
}
\examples{

\donttest{
# As simple as this
threeDspectro(centralis)
threeDspectro(cuvieri)
threeDspectro(kroyeri)

# Controling some arguments
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4))
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4), dBlevel=50)

# As points
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4),
              samp.grid=TRUE, plot.type="points")
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4),
              samp.grid=TRUE, plot.type="points", x.length = 20, y.length = 50)

# As lines
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4), plot.type = "lines")
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4),
              plot.type = "lines", along="y")
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4),
              plot.type = "lines", along="y", skip.lines=18, space.lines=0.8)

# Try different colors
threeDspectro(cuvieri, color=seewave::reverse.terrain.colors(80),
              samp.grid=FALSE, tlim=c(0, 0.5), flim=c(0, 4))
threeDspectro(cuvieri, color=seewave::reverse.cm.colors(80),
              samp.grid=FALSE, tlim=c(0, 0.5), flim=c(0, 4))
threeDspectro(cuvieri, color=grDevices::heat.colors(80),
              samp.grid=FALSE, tlim=c(0, 0.5), flim=c(0, 4))

# Rotation
threeDspectro(cuvieri, tlim=c(0, 0.5), flim=c(0, 4), rotate.Xaxis=40, rotate.Yaxis=50)

# Export your graph
threeDspectro(cuvieri, plot.exp=TRUE, store.at=tempdir(), tlim=c(0,0.5), flim=c(0,4))
}

}
\references{
MacLeod, N., Krieger, J. & Jones, K. E. (2013). Geometric morphometric approaches to acoustic signal analysis in mammalian biology. \emph{Hystrix, the Italian Journal of Mammalogy, 24}(1), 110-125.

Rocha, P. & Romano, P. (2021) The shape of sound: A new \code{R} package that crosses the bridge between Bioacoustics and Geometric Morphometrics. \emph{Methods in Ecology and Evolution, 12}(6), 1115-1121.
}
\seealso{
\code{\link{spectro}}, \code{\link{seewave}}, \code{\link{eigensound}}, \code{\link{align.wave}}, \code{\link{persp3D}}, \code{\link{plot3D}}, \code{\link{align.wave}}

Useful links:
\itemize{
\item{\url{https://github.com/p-rocha/SoundShape}}
\item{Report bugs at \url{https://github.com/p-rocha/SoundShape/issues}}}
}
\author{
Pedro Rocha
}
