% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spades-core-package.R
\docType{package}
\name{SpaDES.core-package}
\alias{SpaDES.core}
\alias{SpaDES.core-package}
\title{Categorized overview of the \code{SpaDES.core} package}
\description{
\if{html}{\figure{SpaDES.png}{options: width=100 alt="SpaDES logo" align="right"}}
\if{latex}{\figure{SpaDES.png}{options: width=0.5in}}

This package allows implementation a variety of simulation-type models,
with a focus on spatially explicit models.
The core simulation components are built upon a discrete event simulation
framework that facilitates modularity, and easily enables the user to
include additional functionality by running user-built simulation modules.
Included are numerous tools to visualize various spatial data formats,
as well as non-spatial data. Much work has been done to speed up the core
of the DES, with current benchmarking as low as 56 microseconds overhead for
each event (including scheduling, sorting event queue, spawning event etc.) or
38 microseconds if there is no sorting (i.e., no sorting occurs under simple conditions).
Under most event conditions, therefore, the DES itself will contribute
very minimally compared to the content of the events, which may often be
milliseconds to many seconds each event.

Bug reports: \url{https://github.com/PredictiveEcology/SpaDES.core/issues}

Module repository: \url{https://github.com/PredictiveEcology/SpaDES-modules}

Wiki: \url{https://github.com/PredictiveEcology/SpaDES/wiki}

------------------------------------------------------------------------------------------
}
\section{1 Spatial discrete event simulation (\code{SpaDES})}{


A collection of top-level functions for doing spatial discrete event simulation.

\subsection{1.1 Simulations}{
  There are two workhorse functions that initialize and run a simulation, and
  third function for doing multiple spades runs:

  \tabular{ll}{
    \code{\link{simInit}} \tab Initialize a new simulation\cr
    \code{\link{spades}} \tab Run a discrete event simulation\cr
    \code{experiment} \tab In \code{SpaDES.experiment} package.
                                  Run multiple \code{\link{spades}} calls\cr
    \code{experiment2} \tab In \code{SpaDES.experiment} package.
                                  Run multiple \code{\link{spades}} calls\cr
  }
}

\subsection{1.2 Events}{
  Within a module, important simulation functions include:

  \tabular{ll}{
    \code{\link{scheduleEvent}} \tab Schedule a simulation event\cr
    \code{\link{scheduleConditionalEvent}} \tab Schedule a conditional simulation event\cr
    \code{removeEvent} \tab Remove an event from the simulation queue (not yet implemented)\cr
  }
}
}

\section{2 The \code{simList} object class}{


The principle exported object class is the \code{simList}.
All \code{SpaDES} simulations operate on this object class.

\tabular{ll}{
  \code{\link{simList}} \tab The 'simList' class\cr
}

------------------------------------------------------------------------------------------
}

\section{3 \code{simList} methods}{


Collections of commonly used functions to retrieve or set slots (and their elements)
of a \code{\link{simList}} object are summarized further below.

\subsection{3.1 Simulation parameters}{
  \tabular{ll}{
     \code{\link{globals}} \tab List of global simulation parameters.\cr
     \code{\link{params}} \tab Nested list of all simulation parameter.\cr
     \code{\link{P}} \tab Namespaced version of \code{\link{params}}
                        (i.e., do not have to specify module name).\cr
  }
}

\subsection{3.2 loading from disk, saving to disk}{
  \tabular{ll}{
     \code{\link{inputs}} \tab List of loaded objects used in simulation. (advanced)\cr
     \code{\link{outputs}} \tab List of objects to save during simulation. (advanced)\cr
  }
}

\subsection{3.3 objects in the \code{simList}}{
  \tabular{ll}{
     \code{\link{ls}}, \code{\link{objects}} \tab Names of objects referenced by the simulation environment.\cr
     \code{\link{ls.str}} \tab List the structure of the simList objects.\cr
     \code{\link{objs}} \tab List of objects referenced by the simulation environment.\cr
  }
}

\subsection{3.4 Simulation paths}{
  Accessor functions for the \code{paths} slot and its elements.
  \tabular{ll}{
     \code{\link{cachePath}} \tab Global simulation cache path.\cr
     \code{\link{modulePath}} \tab Global simulation module path.\cr
     \code{\link{inputPath}} \tab Global simulation input path.\cr
     \code{\link{outputPath}} \tab Global simulation output path.\cr
     \code{\link{rasterPath}} \tab Global simulation temporary raster path.\cr
     \code{\link{paths}} \tab Global simulation paths (cache, modules, inputs, outputs, rasters).\cr
  }
}

\subsection{3.5 Simulation times}{
  Accessor functions for the \code{simtimes} slot and its elements.

  \tabular{ll}{
     \code{\link{time}} \tab Current simulation time, in units of longest module.\cr
     \code{\link{start}} \tab Simulation start time, in units of longest module.\cr
     \code{\link{end}} \tab Simulation end time, in units of longest module.\cr
     \code{\link{times}} \tab List of all simulation times (current, start, end), in units of longest module..\cr
  }
}

\subsection{3.6 Simulation event queues}{
  Accessor functions for the \code{events} and \code{completed} slots.
  By default, the event lists are shown when the \code{simList} object is printed,
  thus most users will not require direct use of these methods.

  \tabular{ll}{
     \code{\link{events}} \tab Scheduled simulation events (the event queue). (advanced)\cr
     \code{\link{current}} \tab Currently executing event. (advanced)\cr
     \code{\link{completed}} \tab Completed simulation events. (advanced)\cr
     \code{\link{elapsedTime}} \tab The amount of clock time that modules & events use\cr
  }
}

\subsection{3.7 Modules, dependencies, packages}{
  Accessor functions for the \code{depends}, \code{modules}, and \code{.loadOrder} slots.
  These are included for advanced users.

  \tabular{ll}{
     \code{\link{depends}} \tab List of simulation module dependencies. (advanced)\cr
     \code{\link{modules}} \tab List of simulation modules to be loaded. (advanced)\cr
     \code{\link{packages}} \tab Vector of required R libraries of all modules. (advanced)\cr
  }
}

\subsection{3.8 \code{simList} environment}{
  The \code{\link{simList}} has a slot called \code{.xData} which is an environment.
  All objects in the \code{simList} are actually in this environment,
  i.e., the \code{simList} is not a \code{list}.
  In R, environments use pass-by-reference semantics, which means that copying
  a \code{simList} object using normal R assignment operation (e.g., \code{sim2 <- sim1}),
  will not copy the objects contained within the \code{.xData} slot.
  The two objects (\code{sim1} and \code{sim2}) will share identical objects
  within that slot. Sometimes, this not desired, and a true copy is required.

  \tabular{ll}{
     \code{\link{envir}} \tab Access the environment of the simList directly (advanced)\cr
     \code{\link{copy}} \tab Deep copy of a simList. (advanced)\cr
  }
}

\subsection{3.9 Checkpointing}{
  \tabular{lll}{
     Accessor method \tab Module \tab Description\cr
     \code{\link{checkpointFile}} \tab \code{.checkpoint} \tab Name of the checkpoint file. (advanced)\cr
     \code{\link{checkpointInterval}} \tab \code{.checkpoint} \tab The simulation checkpoint interval. (advanced)\cr
   }
 }

\subsection{3.10 Progress Bar}{
  \tabular{lll}{
     \code{\link{progressType}} \tab \code{.progress} \tab Type of graphical progress bar used. (advanced)\cr
     \code{\link{progressInterval}} \tab \code{.progress} \tab Interval for the progress bar. (advanced)\cr
  }
}

------------------------------------------------------------------------------------------
}

\section{4 Module operations}{


\subsection{4.1 Creating, distributing, and downloading modules}{
  Modules are the basic unit of \code{SpaDES}.
  These are generally created and stored locally, or are downloaded from remote
  repositories, including our
  \href{https://github.com/PredictiveEcology/SpaDES-modules}{SpaDES-modules}
  repository on GitHub.

  \tabular{ll}{
    \code{\link{checksums}} \tab Verify (and optionally write) checksums for a module's data files.\cr
    \code{\link{downloadModule}} \tab Open all modules nested within a base directory.\cr
    \code{\link{getModuleVersion}} \tab Get the latest module version # from module repository.\cr
    \code{\link{newModule}} \tab Create new module from template.\cr
    \code{\link{newModuleDocumentation}} \tab Create empty documentation for a new module.\cr
    \code{\link{openModules}} \tab Open all modules nested within a base directory.\cr
    \code{\link{moduleMetadata}} \tab Shows the module metadata.\cr
    \code{\link{zipModule}} \tab Zip a module and its associated files.\cr
  }
}

\subsection{4.2 Module metadata}{
  Each module requires several items to be defined.
  These comprise the metadata for that module (including default parameter
  specifications, inputs and outputs), and are currently written at the top of
  the module's \code{.R} file.

  \tabular{ll}{
    \code{\link{defineModule}} \tab Define the module metadata\cr
    \code{\link{defineParameter}} \tab Specify a parameter's name, value and set a default\cr
    \code{\link{expectsInput}} \tab Specify an input object's name, class, description, \code{sourceURL} and other specifications\cr
    \code{\link{createsOutput}} \tab Specify an output object's name, class, description and other specifications\cr
  }

  There are also accessors for many of the metadata entries:
  \tabular{ll}{
    \code{\link{timeunit}} \tab Accesses metadata of same name\cr
    \code{\link{citation}} \tab Accesses metadata of same name\cr
    \code{\link{documentation}} \tab Accesses metadata of same name\cr
    \code{\link{reqdPkgs}} \tab Accesses metadata of same name\cr
    \code{\link{inputObjects}} \tab Accesses metadata of same name\cr
    \code{\link{outputObjects}} \tab Accesses metadata of same name\cr
  }
}

\subsection{4.3 Module dependencies}{
  Once a set of modules have been chosen, the dependency information is automatically
  calculated once simInit is run. There are several functions to assist with dependency
  information:

  \tabular{ll}{
    \code{\link{depsEdgeList}} \tab Build edge list for module dependency graph\cr
    \code{\link{depsGraph}} \tab Build a module dependency graph using \code{igraph}\cr
  }
}

------------------------------------------------------------------------------------------
}

\section{5 Module functions}{


\emph{A collection of functions that help with making modules can be found in
the suggested \code{SpaDES.tools} package, and are summarized below.}

\subsection{5.1 Spatial spreading/distances methods}{
  Spatial contagion is a key phenomenon for spatially explicit simulation models.
  Contagion can be modelled using discrete approaches or continuous approaches.
  Several \code{SpaDES.tools} functions assist with these:

  \tabular{ll}{
    \code{\link[SpaDES.tools]{adj}} \tab An optimized (i.e., faster) version of \code{\link[raster]{adjacent}}\cr
    \code{\link[SpaDES.tools]{cir}} \tab Identify pixels in a circle around a \code{\link[sp:SpatialPoints-class]{SpatialPoints*}} object\cr
    \code{\link[SpaDES.tools:distanceFromEachPoint]{directionFromEachPoint}} \tab Fast calculation of direction and distance surfaces\cr
    \code{\link[SpaDES.tools]{distanceFromEachPoint}} \tab Fast calculation of distance surfaces\cr
    \code{\link[SpaDES.tools]{rings}} \tab Identify rings around focal cells (e.g., buffers and donuts)\cr
    \code{\link[SpaDES.tools]{spokes}} \tab Identify outward radiating spokes from initial points\cr
    \code{\link[SpaDES.tools]{spread}} \tab Contagious cellular automata\cr
    \code{\link[SpaDES.tools]{spread2}} \tab Contagious cellular automata, different algorithm, more robust\cr
    \code{\link[SpaDES.tools]{wrap}} \tab Create a torus from a grid\cr
  }
}

\subsection{5.2 Spatial agent methods}{
  Agents have several methods and functions specific to them:

  \tabular{ll}{
    \code{\link[SpaDES.tools]{crw}} \tab Simple correlated random walk function\cr
    \code{\link[SpaDES.tools]{heading}} \tab Determines the heading between \code{SpatialPoints*}\cr
    \code{\link[quickPlot]{makeLines}} \tab Makes \code{SpatialLines} object for, e.g., drawing arrows\cr
    \code{\link[SpaDES.tools:crw]{move}} \tab A meta function that can currently only take "crw"\cr
    \code{\link[SpaDES.tools:specnumperpatch-probs]{specificNumPerPatch}} \tab Initiate a specific number of agents per patch\cr
  }
}

\subsection{5.3 GIS operations}{
  In addition to the vast amount of GIS operations available in R (mostly from
  contributed packages such as \code{sp}, \code{raster}, \code{maps}, \code{maptools}
  and many others), we provide the following GIS-related functions:

  \tabular{ll}{
    \code{\link{equalExtent}} \tab Assess whether a list of extents are all equal\cr
  }
}

\subsection{5.4 'Map-reduce'--type operations}{
  These functions convert between reduced and mapped representations of the same data.
  This allows compact representation of, e.g., rasters that have many individual pixels
  that share identical information.

  \tabular{ll}{
    \code{\link[SpaDES.tools]{rasterizeReduced}} \tab Convert reduced representation to full raster.\cr
  }
}

\subsection{5.5 Colors in \code{Raster*} objects}{
  We likely will not want the default colours for every map.
  Here are several helper functions to add to, set and get colors of \code{Raster*} objects:

  \tabular{ll}{
    \code{\link[quickPlot:getSetColors]{setColors}} \tab Set colours for plotting \code{Raster*} objects\cr
    \code{\link{getColors}} \tab Get colours in a \code{Raster*} objects\cr
    \code{\link{divergentColors}} \tab Create a colour palette with diverging colours around a middle\cr
  }
}

\subsection{5.6 Random Map Generation}{
  It is often useful to build dummy maps with which to build simulation models before all data are available.
  These dummy maps can later be replaced with actual data maps.

  \tabular{ll}{
    \code{\link[SpaDES.tools]{gaussMap}} \tab Creates a random map using Gaussian random fields\cr
    \code{\link[SpaDES.tools]{randomPolygons}} \tab Creates a random polygon with specified number of classes\cr
  }
}

\subsection{5.7 Checking for the existence of objects}{
  \code{SpaDES} modules will often require the existence of objects in the \code{simList}.
  These are helpers for assessing this:

  \tabular{ll}{
    \code{\link{checkObject}} \tab Check for a existence of an object within a \code{simList} \cr
    \code{\link[Require]{checkPath}} \tab Checks the specified filepath for formatting consistencies\cr
  }
}

\subsection{5.8 SELES-type approach to simulation}{
  These functions are essentially skeletons and are not fully implemented.
  They are intended to make translations from \href{http://www.gowlland.ca/}{SELES}.
  You must know how to use SELES for these to be useful:

  \tabular{ll}{
    \code{\link[SpaDES.tools:SELESagentLocation]{agentLocation}} \tab Agent location\cr
    \code{\link[SpaDES.tools]{initiateAgents}} \tab Initiate agents into a \code{SpatialPointsDataFrame}\cr
    \code{\link[SpaDES.tools:SELESnumAgents]{numAgents}} \tab Number of agents\cr
    \code{\link[SpaDES.tools:SELESprobInit]{probInit}} \tab Probability of initiating an agent or event\cr
    \code{\link[SpaDES.tools:SELEStransitions]{transitions}} \tab Transition probability\cr
  }
}

\subsection{5.9 Miscellaneous}{
  Functions that may be useful within a \code{SpaDES} context:

  \tabular{ll}{
    \code{\link[SpaDES.tools]{inRange}} \tab Test whether a number lies within range [a,b]\cr
    \code{\link{layerNames}} \tab Get layer names for numerous object classes\cr
    \code{\link{loadPackages}} \tab Simple wrapper for loading packages\cr
    \code{\link{numLayers}} \tab Return number of layers\cr
    \code{\link{paddedFloatToChar}} \tab Wrapper for padding (e.g., zeros) floating numbers to character\cr
    \code{\link{updateList}} \tab Update values in a named list\cr
  }
}

------------------------------------------------------------------------------------------
}

\section{6 Caching simulations and simulation components}{


\emph{Simulation caching uses the \code{reproducible} package.}

Caching can be done in a variety of ways, most of which are up to the module developer.
However, the one most common usage would be to cache a simulation run.
This might be useful if a simulation is very long, has been run once, and the
goal is just to retrieve final results.
This would be an alternative to manually saving the outputs.

See example in \code{\link{spades}}, achieved by using \code{cache = TRUE} argument.

\tabular{ll}{
  \code{\link[reproducible]{Cache}} \tab Caches a function, but often accessed as arg in \code{\link{spades}}\cr
  \code{\link[reproducible:cache-tools]{showCache}} \tab Shows information about the objects in the cache\cr
  \code{\link[reproducible:cache-tools]{clearCache}} \tab Removes objects from the cache\cr
  \code{\link[reproducible:cache-tools]{keepCache}} \tab Keeps only the objects described\cr
}

A module developer can build caching into their module by creating cached versions of their
functions.

------------------------------------------------------------------------------------------
}

\section{7 Plotting}{


\emph{Much of the underlying plotting functionality is provided by \pkg{quickPlot}.}

There are several user-accessible plotting functions that are optimized for modularity
and speed of plotting:

Commonly used:
\tabular{ll}{
  \code{\link{Plot}} \tab The workhorse plotting function\cr
}

Simulation diagrams:
\tabular{ll}{
  \code{\link{eventDiagram}} \tab Gantt chart representing the events in a completed simulation.\cr
  \code{\link{moduleDiagram}} \tab Network diagram of simplified module (object) dependencies.\cr
  \code{\link{objectDiagram}} \tab Sequence diagram of detailed object dependencies.\cr
}

Other useful plotting functions:
\tabular{ll}{
  \code{\link{clearPlot}} \tab Helpful for resolving many errors\cr
  \code{\link{clickValues}} \tab Extract values from a raster object at the mouse click location(s)\cr
  \code{\link{clickExtent}} \tab Zoom into a raster or polygon map that was plotted with \code{\link{Plot}}\cr
  \code{\link{clickCoordinates}} \tab Get the coordinates, in map units, under mouse click\cr
  \code{\link{dev}} \tab Specify which device to plot on, making a non-RStudio one as default\cr
  \code{\link{newPlot}} \tab Open a new default plotting device\cr
  \code{\link{rePlot}} \tab Replots all elements of device for refreshing or moving plot\cr
}

------------------------------------------------------------------------------------------
}

\section{8 File operations}{


In addition to R's file operations, we have added several here to aid in bulk
loading and saving of files for simulation purposes:

\tabular{ll}{
  \code{\link{loadFiles}} \tab Load simulation objects according to a filelist\cr
  \code{\link{rasterToMemory}} \tab Read a raster from file to RAM\cr
  \code{\link{saveFiles}} \tab Save simulation objects according to outputs and params\cr
}

------------------------------------------------------------------------------------------
}

\section{9 Sample modules included in package}{


Several dummy modules are included for testing of functionality.
These can be found with \code{file.path(find.package("SpaDES.core"), "sampleModules")}.

\tabular{ll}{
  \code{randomLandscapes} \tab Imports, updates, and plots several raster map layers\cr
  \code{caribouMovement} \tab A simple agent-based (a.k.a., individual-based) model\cr
  \code{fireSpread} \tab A simple model of a spatial spread process\cr
}

------------------------------------------------------------------------------------------
}

\section{10 Package options}{


\code{SpaDES} packages use the following \code{\link{options}} to configure behaviour:

\itemize{
  \item \code{spades.browserOnError}: If \code{TRUE}, the default, then any
  error rerun the same event with \code{debugonce} called on it to allow editing
  to be done. When that browser is continued (e.g., with 'c'), then it will save it
  reparse it into the simList and rerun the edited version. This may allow a spades
  call to be recovered on error, though in many cases that may not be the correct
  behaviour. For example, if the simList gets updated inside that event in an iterative
  manner, then each run through the event will cause that iteration to occur.
  When this option is \code{TRUE}, then the event will be run at least 3 times: the
  first time makes the error, the second time has \code{debugonce} and the third time
  is after the error is addressed. \code{TRUE} is likely somewhat slower.

  \item \code{reproducible.cachePath}: The default local directory in which to
  cache simulation outputs.
  Default is a temporary directory (typically \code{/tmp/RtmpXXX/SpaDES/cache}).

  \item \code{spades.inputPath}: The default local directory in which to
  look for simulation inputs.
  Default is a temporary directory (typically \code{/tmp/RtmpXXX/SpaDES/inputs}).

  \item \code{spades.debug}: The default debugging value \code{debug}
  argument in \code{spades()}. Default is \code{TRUE}.

  \item \code{spades.lowMemory}: If true, some functions will use more memory
    efficient (but slower) algorithms. Default \code{FALSE}.

  \item \code{spades.moduleCodeChecks}: Should the various code checks be run
  during \code{simInit}. These are passed to codetools::checkUsage.
  Default is given by the function, plus these :\code{list(suppressParamUnused = FALSE,
  suppressUndefined = TRUE, suppressPartialMatchArgs = FALSE, suppressNoLocalFun = TRUE,
  skipWith = TRUE)}.

  \item \code{spades.modulePath}: The default local directory where modules
    and data will be downloaded and stored.
    Default is a temporary directory (typically \code{/tmp/RtmpXXX/SpaDES/modules}).

  \item \code{spades.moduleRepo}: The default GitHub repository to use when
    downloading modules via \code{downloadModule}.
    Default \code{"PredictiveEcology/SpaDES-modules"}.

  \item \code{spades.nCompleted}: The maximum number of completed events to
    retain in the \code{completed} event queue. Default \code{1000L}.

  \item \code{spades.outputPath}: The default local directory in which to
  save simulation outputs.
  Default is a temporary directory (typically \code{/tmp/RtmpXXX/SpaDES/outputs}).

  \item \code{spades.recoveryMode}: If this a numeric > 0 or TRUE, then the
  discrete event simulator will take a snapshot of the objects in the simList
  that might change (based on metadata \code{outputObjects} for that module), prior to
  initiating every event. This will allow the
  user to be able to recover in case of an error or manual interruption (e.g., \code{Esc}).
  If this is numeric, a copy of that number of "most
  recent events" will be maintained so that the user can recover and restart
  > 1 event in the past, i.e., redo some of the "completed" events. Default is
  \code{TRUE}, i.e., it will keep the state of the \code{simList}
  at the start of the current event. This can be recovered with \code{restartSpades}
  and the differences can be seen in a hidden object in the stashed \code{simList.}
  There is a message which describes how to find that.

  \item \code{spades.switchPkgNamespaces}: Should the search path be modified
    to ensure a module's required packages are listed first?
    Default \code{FALSE} to keep computational overhead down. If \code{TRUE},
    there should be no name conflicts among package objects,
    but it is much slower, especially if the events are themselves fast.

  \item \code{spades.tolerance}: The default tolerance value used for floating
    point number comparisons. Default \code{.Machine$double.eps^0.5}.

  \item \code{spades.useragent}: The default user agent to use for downloading
    modules from GitHub.com. Default \code{"https://github.com/PredictiveEcology/SpaDES"}.
}
}

\seealso{
\code{\link{spadesOptions}}
}
\author{
\strong{Maintainer}: Alex M Chubaty \email{alex.chubaty@gmail.com} (\href{https://orcid.org/0000-0001-7146-8135}{ORCID})

Authors:
\itemize{
  \item Eliot J B McIntire \email{eliot.mcintire@canada.ca} (\href{https://orcid.org/0000-0002-6914-8316}{ORCID})
}

Other contributors:
\itemize{
  \item Yong Luo \email{yluo1@lakeheadu.ca} [contributor]
  \item Steve Cumming \email{Steve.Cumming@sbf.ulaval.ca} [contributor]
  \item Ceres Barros \email{cbarros@mail.ubc.ca} (\href{https://orcid.org/0000-0003-4036-977X}{ORCID}) [contributor]
  \item Her Majesty the Queen in Right of Canada, as represented by the Minister of Natural Resources Canada [copyright holder]
}

}
