% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-repository.R
\name{checkModuleLocal}
\alias{checkModuleLocal}
\alias{checkModuleLocal,character,character,character-method}
\alias{checkModuleLocal,character,ANY,ANY-method}
\title{Check for the existence of a module locally}
\usage{
checkModuleLocal(name, path, version)

\S4method{checkModuleLocal}{character,character,character}(name, path, version)

\S4method{checkModuleLocal}{character,ANY,ANY}(name, path, version)
}
\arguments{
\item{name}{Character string giving the module name.}

\item{path}{Local path to modules directory.
Default is specified by the global option \code{spades.modulePath}.}

\item{version}{Character specifying the desired module version.}
}
\value{
Logical indicating presence of the module (invisibly).
}
\description{
Looks the module path for a module named \code{name}, and checks for existence
of all essential module files listed below.
}
\details{
\itemize{
  \item \file{data/CHECKSUMS.txt}
  \item \file{name.R}
}
}
\author{
Alex Chubaty
}
