% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-template.R
\name{newModuleCode}
\alias{newModuleCode}
\alias{newModuleCode,character,character-method}
\title{Create new module code file}
\usage{
newModuleCode(name, path, ..., events)

\S4method{newModuleCode}{character,character}(name, path, ..., events)
}
\arguments{
\item{name}{Character string specifying the name of the new module.}

\item{path}{Character string. Subdirectory in which to place the new module code file.
The default is the current working directory.}

\item{...}{Additional arguments. Currently, these can be either named
function definitions (which will be added to the \code{simList}) or one or
more of the following:\cr\cr
\describe{
\item{\code{children}}{Required when \code{type = "parent"}. A character vector
specifying the names of child modules.}
\item{\code{open}}{Logical. Should the new module file be opened after creation?
Default \code{TRUE}.}
\item{\code{type}}{Character string specifying one of \code{"child"} (default),
or \code{"parent"}.}
}}

\item{events}{A list of named expressions, each of which is surrounded by \code{{ }}.
A user can specify events here, instead of accepting the default \code{doEvent} function
that comes with the module template. See example for \code{\link[=newModule]{newModule()}}.}
}
\value{
NULL (invisibly). Invoked for its side effect of creating new module code files.
}
\description{
Create new module code file
}
\seealso{
Other module creation helpers: 
\code{\link{newModule}()},
\code{\link{newModuleDocumentation}()},
\code{\link{newModuleTests}()}
}
\author{
Eliot McIntire and Alex Chubaty
}
\concept{module creation helpers}
