% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis.R
\name{fastMask}
\alias{fastMask}
\title{Faster operations on rasters}
\usage{
fastMask(x, polygon)
}
\arguments{
\item{x}{A \code{Raster*} object.}

\item{polygon}{A \code{SpatialPolygons} object.}
}
\value{
A \code{Raster*} object, masked (i.e., smaller extent and/or
        several pixels converted to NA)
}
\description{
These alternatives to \code{mask} and \code{rasterize} are not as general as
the originals, and have not been thoroughly tested.
}
\note{
This is experimental and not all combinations of parameters or object
types will work.
}
\examples{
\dontrun{
library(raster)

Sr1 <- Polygon(cbind(c(2, 4, 4, 0.9, 2), c(2, 3, 5, 4, 2)))
Sr2 <- Polygon(cbind(c(5, 4, 2, 5), c(2, 3, 2, 2)))
Sr3 <- Polygon(cbind(c(4, 4, 5, 10, 4), c(5, 3, 2, 5, 5)))

Srs1 <- Polygons(list(Sr1), "s1")
Srs2 <- Polygons(list(Sr2), "s2")
Srs3 <- Polygons(list(Sr3), "s3")
shp <- SpatialPolygons(list(Srs1, Srs2, Srs3), 1:3)
d <- data.frame(vals = 1:3, other = letters[3:1], stringsAsFactors = FALSE)
row.names(d) <- names(shp)
shp <- SpatialPolygonsDataFrame(shp, data = d)
poly <- list()
poly[[1]] <- raster(raster::extent(shp), vals = 0, res = c(1, 1))
poly[[2]] <- raster(raster::extent(shp), vals = 1, res = c(1, 1))
origStack <- stack(poly)
# original mask function in raster
newStack1 <- mask(origStack, mask = shp)
newStack2 <- fastMask(x = origStack, polygon = shp)

# test all equal
all.equal(newStack1, newStack2)

newStack1 <- stack(newStack1)
newStack2 <- stack(newStack2)

if (interactive()) {
  plot(newStack2[[1]])
  plot(shp, add = TRUE)
}

file.remove("newMap.tif")
}

}
\author{
Eliot Mcintire
}
