% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{neutralLandscapeMap}
\alias{neutralLandscapeMap}
\title{Produce a neutral landscape using a midpoint displacement algorithm}
\usage{
neutralLandscapeMap(x, pad = 10L, ...)
}
\arguments{
\item{x}{A \code{RasterLayer} to use as a template.}

\item{pad}{Integer. Number of cells by which to pad \code{x} internally to ensure
\code{nlm_mpd} produces a raster corresponding to the dimensions of \code{x}.}

\item{...}{Further arguments passed to \code{NLMR::nlm_mpd}}
}
\value{
A \code{RasterLayer} with same extent as \code{x}, with randomly generated values.
}
\description{
This is a wrapper for the \code{nlm_mpd} function in the \code{NLMR} package.
The main addition is that it makes sure that the output raster conforms
in extent with the input raster \code{x}, since \code{nlm_mpd} can output a smaller raster.
}
\examples{
\dontrun{
  if (require(NLMR)) {
    library(raster)
    nx <- ny <- 100L
    r <- raster(nrows = ny, ncols = nx, xmn = -nx/2, xmx = nx/2, ymn = -ny/2, ymx = ny/2)
    map1 <- neutralLandscapeMap(r,
                                roughness = 0.65,
                                rand_dev = 200,
                                rescale = FALSE,
                                verbose = FALSE)
    if (interactive()) Plot(map1)
  }
}
}
\seealso{
\code{nlm_mpd}
}
