% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R, R/stats.R
\docType{methods}
\name{cov}
\alias{cov}
\alias{covar_samp}
\alias{covar_pop}
\alias{cov}
\alias{cov,characterOrColumn-method}
\alias{covar_samp}
\alias{covar_samp,characterOrColumn,characterOrColumn-method}
\alias{covar_pop}
\alias{covar_pop,characterOrColumn,characterOrColumn-method}
\alias{cov,SparkDataFrame-method}
\title{cov}
\usage{
cov(x, ...)

covar_samp(col1, col2)

covar_pop(col1, col2)

\S4method{cov}{characterOrColumn}(x, col2)

\S4method{covar_samp}{characterOrColumn,characterOrColumn}(col1, col2)

\S4method{covar_pop}{characterOrColumn,characterOrColumn}(col1, col2)

\S4method{cov}{SparkDataFrame}(x, colName1, colName2)
}
\arguments{
\item{x}{a Column or a SparkDataFrame.}

\item{...}{additional argument(s). If \code{x} is a Column, a Column
should be provided. If \code{x} is a SparkDataFrame, two column names should
be provided.}

\item{col1}{the first Column.}

\item{col2}{the second Column.}

\item{colName1}{the name of the first column}

\item{colName2}{the name of the second column}
}
\value{
The covariance of the two columns.
}
\description{
Compute the covariance between two expressions.
}
\details{
\code{cov}: Compute the sample covariance between two expressions.

\code{covar_sample}: Alias for \code{cov}.

\code{covar_pop}: Computes the population covariance between two expressions.

\code{cov}: When applied to SparkDataFrame, this calculates the sample covariance of two
numerical columns of \emph{one} SparkDataFrame.
}
\note{
cov since 1.6.0

covar_samp since 2.0.0

covar_pop since 2.0.0

cov since 1.6.0
}
\examples{
\dontrun{
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars))
head(select(df, cov(df$mpg, df$hp), cov("mpg", "hp"),
                covar_samp(df$mpg, df$hp), covar_samp("mpg", "hp"),
                covar_pop(df$mpg, df$hp), covar_pop("mpg", "hp")))}

\dontrun{
cov(df, "mpg", "hp")
cov(df, df$mpg, df$hp)}
}
\seealso{
Other aggregate functions: \code{\link{avg}},
  \code{\link{column_aggregate_functions}},
  \code{\link{corr}}, \code{\link{count}},
  \code{\link{first}}, \code{\link{last}}

Other stat functions: \code{\link{approxQuantile}},
  \code{\link{corr}}, \code{\link{crosstab}},
  \code{\link{freqItems}}, \code{\link{sampleBy}}
}
