% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/streaming.R
\docType{methods}
\name{awaitTermination}
\alias{awaitTermination}
\alias{awaitTermination,StreamingQuery-method}
\title{awaitTermination}
\usage{
awaitTermination(x, timeout = NULL)

\S4method{awaitTermination}{StreamingQuery}(x, timeout = NULL)
}
\arguments{
\item{x}{a StreamingQuery.}

\item{timeout}{time to wait in milliseconds, if omitted, wait indefinitely until \code{stopQuery}
is called or an error has occurred.}
}
\value{
TRUE if query has terminated within the timeout period; nothing if timeout is not
        specified.
}
\description{
Waits for the termination of the query, either by \code{stopQuery} or by an error.
}
\details{
If the query has terminated, then all subsequent calls to this method will return TRUE
immediately.
}
\note{
awaitTermination(StreamingQuery) since 2.2.0

experimental
}
\examples{
\dontrun{ awaitTermination(sq, 10000) }
}
\seealso{
Other StreamingQuery methods: \code{\link{explain}},
  \code{\link{isActive}}, \code{\link{lastProgress}},
  \code{\link{queryName}}, \code{\link{status}},
  \code{\link{stopQuery}}
}
\concept{StreamingQuery methods}
