% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\name{column_math_functions}
\alias{column_math_functions}
\alias{abs,Column-method}
\alias{abs}
\alias{acos,Column-method}
\alias{acos}
\alias{acosh,Column-method}
\alias{acosh}
\alias{asin,Column-method}
\alias{asin}
\alias{asinh,Column-method}
\alias{asinh}
\alias{atan,Column-method}
\alias{atan}
\alias{atanh,Column-method}
\alias{atanh}
\alias{bin,Column-method}
\alias{bin}
\alias{cbrt,Column-method}
\alias{cbrt}
\alias{ceil,Column-method}
\alias{ceil}
\alias{ceiling,Column-method}
\alias{ceiling}
\alias{cos,Column-method}
\alias{cos}
\alias{cosh,Column-method}
\alias{cosh}
\alias{exp,Column-method}
\alias{exp}
\alias{expm1,Column-method}
\alias{expm1}
\alias{factorial,Column-method}
\alias{factorial}
\alias{floor,Column-method}
\alias{floor}
\alias{hex,Column-method}
\alias{hex}
\alias{log,Column-method}
\alias{log}
\alias{log10,Column-method}
\alias{log10}
\alias{log1p,Column-method}
\alias{log1p}
\alias{log2,Column-method}
\alias{log2}
\alias{rint,Column-method}
\alias{rint}
\alias{round,Column-method}
\alias{round}
\alias{bround,Column-method}
\alias{bround}
\alias{signum,Column-method}
\alias{signum}
\alias{sign,Column-method}
\alias{sign}
\alias{sin,Column-method}
\alias{sin}
\alias{sinh,Column-method}
\alias{sinh}
\alias{sqrt,Column-method}
\alias{sqrt}
\alias{tan,Column-method}
\alias{tan}
\alias{tanh,Column-method}
\alias{tanh}
\alias{toDegrees,Column-method}
\alias{toDegrees}
\alias{degrees,Column-method}
\alias{degrees}
\alias{toRadians,Column-method}
\alias{toRadians}
\alias{radians,Column-method}
\alias{radians}
\alias{unhex,Column-method}
\alias{unhex}
\alias{atan2,Column-method}
\alias{atan2}
\alias{hypot,Column-method}
\alias{hypot}
\alias{pmod,Column-method}
\alias{pmod}
\alias{shiftLeft,Column,numeric-method}
\alias{shiftLeft}
\alias{shiftRight,Column,numeric-method}
\alias{shiftRight}
\alias{shiftRightUnsigned,Column,numeric-method}
\alias{shiftRightUnsigned}
\alias{conv,Column,numeric,numeric-method}
\alias{conv}
\title{Math functions for Column operations}
\usage{
bin(x)

bround(x, ...)

cbrt(x)

ceil(x)

conv(x, fromBase, toBase)

hex(x)

hypot(y, x)

pmod(y, x)

rint(x)

shiftLeft(y, x)

shiftRight(y, x)

shiftRightUnsigned(y, x)

signum(x)

degrees(x)

toDegrees(x)

radians(x)

toRadians(x)

unhex(x)

\S4method{abs}{Column}(x)

\S4method{acos}{Column}(x)

\S4method{acosh}{Column}(x)

\S4method{asin}{Column}(x)

\S4method{asinh}{Column}(x)

\S4method{atan}{Column}(x)

\S4method{atanh}{Column}(x)

\S4method{bin}{Column}(x)

\S4method{cbrt}{Column}(x)

\S4method{ceil}{Column}(x)

\S4method{ceiling}{Column}(x)

\S4method{cos}{Column}(x)

\S4method{cosh}{Column}(x)

\S4method{exp}{Column}(x)

\S4method{expm1}{Column}(x)

\S4method{factorial}{Column}(x)

\S4method{floor}{Column}(x)

\S4method{hex}{Column}(x)

\S4method{log}{Column}(x)

\S4method{log10}{Column}(x)

\S4method{log1p}{Column}(x)

\S4method{log2}{Column}(x)

\S4method{rint}{Column}(x)

\S4method{round}{Column}(x)

\S4method{bround}{Column}(x, scale = 0)

\S4method{signum}{Column}(x)

\S4method{sign}{Column}(x)

\S4method{sin}{Column}(x)

\S4method{sinh}{Column}(x)

\S4method{sqrt}{Column}(x)

\S4method{tan}{Column}(x)

\S4method{tanh}{Column}(x)

\S4method{toDegrees}{Column}(x)

\S4method{degrees}{Column}(x)

\S4method{toRadians}{Column}(x)

\S4method{radians}{Column}(x)

\S4method{unhex}{Column}(x)

\S4method{atan2}{Column}(y, x)

\S4method{hypot}{Column}(y, x)

\S4method{pmod}{Column}(y, x)

\S4method{shiftLeft}{Column,numeric}(y, x)

\S4method{shiftRight}{Column,numeric}(y, x)

\S4method{shiftRightUnsigned}{Column,numeric}(y, x)

\S4method{conv}{Column,numeric,numeric}(x, fromBase, toBase)
}
\arguments{
\item{x}{Column to compute on. In \code{shiftLeft}, \code{shiftRight} and
\code{shiftRightUnsigned}, this is the number of bits to shift.}

\item{...}{additional argument(s).}

\item{fromBase}{base to convert from.}

\item{toBase}{base to convert to.}

\item{y}{Column to compute on.}

\item{scale}{round to \code{scale} digits to the right of the decimal point when
\code{scale} > 0, the nearest even number when \code{scale} = 0, and \code{scale} digits
to the left of the decimal point when \code{scale} < 0.}
}
\description{
Math functions defined for \code{Column}.
}
\details{
\code{abs}: Computes the absolute value.

\code{acos}: Returns the inverse cosine of the given value,
as if computed by \code{java.lang.Math.acos()}

\code{acosh}: Computes inverse hyperbolic cosine of the input column.

\code{asin}: Returns the inverse sine of the given value,
as if computed by \code{java.lang.Math.asin()}

\code{asinh}: Computes inverse hyperbolic sine of the input column.

\code{atan}: Returns the inverse tangent of the given value,
as if computed by \code{java.lang.Math.atan()}

\code{atanh}: Computes inverse hyperbolic tangent of the input column.

\code{bin}: Returns the string representation of the binary value
of the given long column. For example, bin("12") returns "1100".

\code{cbrt}: Computes the cube-root of the given value.

\code{ceil}: Computes the ceiling of the given value.

\code{ceiling}: Alias for \code{ceil}.

\code{cos}: Returns the cosine of the given value,
as if computed by \code{java.lang.Math.cos()}. Units in radians.

\code{cosh}: Returns the hyperbolic cosine of the given value,
as if computed by \code{java.lang.Math.cosh()}.

\code{exp}: Computes the exponential of the given value.

\code{expm1}: Computes the exponential of the given value minus one.

\code{factorial}: Computes the factorial of the given value.

\code{floor}: Computes the floor of the given value.

\code{hex}: Computes hex value of the given column.

\code{log}: Computes the natural logarithm of the given value.

\code{log10}: Computes the logarithm of the given value in base 10.

\code{log1p}: Computes the natural logarithm of the given value plus one.

\code{log2}: Computes the logarithm of the given column in base 2.

\code{rint}: Returns the double value that is closest in value to the argument and
is equal to a mathematical integer.

\code{round}: Returns the value of the column rounded to 0 decimal places
using HALF_UP rounding mode.

\code{bround}: Returns the value of the column \code{e} rounded to \code{scale} decimal places
using HALF_EVEN rounding mode if \code{scale} >= 0 or at integer part when \code{scale} < 0.
Also known as Gaussian rounding or bankers' rounding that rounds to the nearest even number.
bround(2.5, 0) = 2, bround(3.5, 0) = 4.

\code{signum}: Computes the signum of the given value.

\code{sign}: Alias for \code{signum}.

\code{sin}: Returns the sine of the given value,
as if computed by \code{java.lang.Math.sin()}. Units in radians.

\code{sinh}: Returns the hyperbolic sine of the given value,
as if computed by \code{java.lang.Math.sinh()}.

\code{sqrt}: Computes the square root of the specified float value.

\code{tan}: Returns the tangent of the given value,
as if computed by \code{java.lang.Math.tan()}.
Units in radians.

\code{tanh}: Returns the hyperbolic tangent of the given value,
as if computed by \code{java.lang.Math.tanh()}.

\code{toDegrees}: Converts an angle measured in radians to an approximately equivalent angle
measured in degrees.

\code{degrees}: Converts an angle measured in radians to an approximately equivalent angle
measured in degrees.

\code{toRadians}: Converts an angle measured in degrees to an approximately equivalent angle
measured in radians.

\code{radians}: Converts an angle measured in degrees to an approximately equivalent angle
measured in radians.

\code{unhex}: Inverse of hex. Interprets each pair of characters as a hexadecimal number
and converts to the byte representation of number.

\code{atan2}: Returns the angle theta from the conversion of rectangular coordinates
(x, y) to polar coordinates (r, theta),
as if computed by \code{java.lang.Math.atan2()}. Units in radians.

\code{hypot}: Computes "sqrt(a^2 + b^2)" without intermediate overflow or underflow.

\code{pmod}: Returns the positive value of dividend mod divisor.
Column \code{x} is divisor column, and column \code{y} is the dividend column.

\code{shiftLeft}: Shifts the given value numBits left. If the given value is a long value,
this function will return a long value else it will return an integer value.

\code{shiftRight}: (Signed) shifts the given value numBits right. If the given value is a long
value, it will return a long value else it will return an integer value.

\code{shiftRightUnsigned}: (Unsigned) shifts the given value numBits right. If the given value is
a long value, it will return a long value else it will return an integer value.

\code{conv}: Converts a number in a string column from one base to another.
}
\note{
abs since 1.5.0

acos since 1.5.0

acosh since 3.1.0

asin since 1.5.0

asinh since 3.1.0

atan since 1.5.0

atanh since 3.1.0

bin since 1.5.0

cbrt since 1.4.0

ceil since 1.5.0

ceiling since 1.5.0

cos since 1.5.0

cosh since 1.5.0

exp since 1.5.0

expm1 since 1.5.0

factorial since 1.5.0

floor since 1.5.0

hex since 1.5.0

log since 1.5.0

log10 since 1.5.0

log1p since 1.5.0

log2 since 1.5.0

rint since 1.5.0

round since 1.5.0

bround since 2.0.0

signum since 1.5.0

sign since 1.5.0

sin since 1.5.0

sinh since 1.5.0

sqrt since 1.5.0

tan since 1.5.0

tanh since 1.5.0

toDegrees since 1.4.0

degrees since 3.0.0

toRadians since 1.4.0

radians since 3.0.0

unhex since 1.5.0

atan2 since 1.5.0

hypot since 1.4.0

pmod since 1.5.0

shiftLeft since 1.5.0

shiftRight since 1.5.0

shiftRightUnsigned since 1.5.0

conv since 1.5.0
}
\examples{
\dontrun{
# Dataframe used throughout this doc
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars))
tmp <- mutate(df, v1 = log(df$mpg), v2 = cbrt(df$disp),
                  v3 = bround(df$wt, 1), v4 = bin(df$cyl),
                  v5 = hex(df$wt), v6 = degrees(df$gear),
                  v7 = atan2(df$cyl, df$am), v8 = hypot(df$cyl, df$am),
                  v9 = pmod(df$hp, df$cyl), v10 = shiftLeft(df$disp, 1),
                  v11 = conv(df$hp, 10, 16), v12 = sign(df$vs - 0.5),
                  v13 = sqrt(df$disp), v14 = ceil(df$wt))
head(tmp)}
}
\concept{math functions}
