% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dense_to_sparse}
\alias{dense_to_sparse}
\title{Generate sparse matrix representation of a matrix}
\usage{
dense_to_sparse(mat)
}
\arguments{
\item{mat}{A matrix}
}
\value{
A list with the matrix in compressed row storage format.
}
\description{
Generate sparse matrix representation of a matrix
}
\examples{
M <- diag(10)
#put a few random values in
M[lower.tri(M)][seq(1,45,by=5)] <- c(0.1,0.5,0.9,0.6,0.8,0.9,0.2,0.3,0.1)
M[upper.tri(M)][seq(1,45,by=5)] <- c(0.1,0.5,0.9,0.6,0.8,0.9,0.2,0.3,0.1)
L <- dense_to_sparse(M)
}
