% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{plot.spatpca}
\alias{plot.spatpca}
\title{Plot eigenfunctions from a spatpca object}
\usage{
\method{plot}{spatpca}(x, ...)
}
\arguments{
\item{x}{"spatpca" object.}

\item{...}{Additional arguments for generic plot.}
}
\value{
NULL.
}
\description{
Produce plots of eigenfunctions according to a spatpca object.
}
\examples{
\dontrun{
s.1D <- as.matrix(seq(-5, 5, length = 50))
Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2), "F")
Y.1D <- rnorm(n = 100, sd = 3)\%*\%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
Phi.est <- spatpca(Y = Y.1D, sx = s.1D, K = 1, tau1 = 100, tau2 = 100)
plot(Phi.est)}}
\author{
Wen-Ting Wang and Hsin-Cheng Huang
}

\seealso{
\code{\link{spatpca}}, \code{\link{cv.spatpca}}
}

