% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotDressedEns.R
\name{PlotDressedEns}
\alias{PlotDressedEns}
\title{Plot a series forecast distributions of dressed ensembles}
\usage{
PlotDressedEns(dressed.ens, add = FALSE, obs = NULL, plot.ens = FALSE,
  plot.ker = FALSE)
}
\arguments{
\item{dressed.ens}{An object of class `dressed.ens`. See ?DressEnsemble for details.}

\item{add}{logical, default=FALSE. If TRUE, no new plotting device is created and everything is added to an existing device.}

\item{obs}{A vector of length N, default=NULL. The verifying observations corresponding to the individual ensemble forecasts. If a vector of length N is provided (N = nrow(dressed.ens[["ens"]]), the values are added to the plot as markers.}

\item{plot.ens}{logical, default=FALSE. If TRUE, the centers of the individual dressing kernels are indicated by markers.}

\item{plot.ker}{logical, default=FALSE. If TRUE, the individual dressing kernels are plotted.}
}
\value{
none
}
\description{
Plot a series forecast distributions of dressed ensembles
}
\examples{
data(eurotempforecast)
d.ens <- DressEnsemble(ens)
PlotDressedEns(d.ens, add=FALSE, obs=obs, plot.ens=FALSE, plot.ker=TRUE)
}
\seealso{
DressEnsemble
}
