% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rankhist.R
\name{Rankhist}
\alias{Rankhist}
\title{Rank histogram for ensemble forecasts}
\usage{
Rankhist(ens, obs, reduce.bins = 1, handle.na = "na.fail")
}
\arguments{
\item{ens}{matrix of dimension (N,K). An archive of K-member ensemble forecasts for N time instances.}

\item{obs}{vector of length N. The corresponding verifying observations.}

\item{reduce.bins}{number of adjacent bins that will be merged into one bin; has to be a divisor of K+1}

\item{handle.na}{how should missing values in ensemble and observation data be handled; possible values are 'na.fail' (fails if any data is missing) and 'use.complete' (only uses times where all ensemble members and obs are available); default: 'na.fail'}
}
\value{
a vector of length (K+1)/reduce.bins containing the rank counts
}
\description{
Calculate the rank histogram for an archive of ensemble forecasts and their corresponding verifying observations.
}
\examples{
data(eurotempforecast)
rh <- Rankhist(ens, obs)
}
\seealso{
PlotRankhist, TestRankhist
}
