% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sphere_montekhat}
\alias{sphere_montekhat}
\title{K-functions under complete spatial randomness (CSR) by Monte Carlo tests}
\usage{
sphere_montekhat(n, nsim, dis)
}
\arguments{
\item{n}{Number of observed points}

\item{nsim}{Number of simulations for K-function}

\item{dis}{Vector of values for the argument r (from 0 to pi), at which K(r) is evaluated. By default, dis = seq(from=0,to=pi,by=0.1).}
}
\value{
Kci Simulated K-functions under CSR
}
\description{
Monte Carlo confidence intervals of K-functions under CSR are provided for point-pattern analysis.
}
\references{
Robeson, S.M., Li, A., Huang, C., 2014. Point-pattern analysis on the sphere. Spatial Statistics. 10, 76-86.
}
\examples{
#Spherical K function (minus CSR) with 95\% confidence intervals
#for point patterns associated with 172 upper-air monitoring stations points

data(GUAN)
latg<-GUAN[,4]
long<-GUAN[,5]
d<-seq(from=0,to=pi,by=0.1)
nd<-length(d)
d[nd]<-pi
khatsg<-sphere_khat(latg,long,d)
Kcig<-sphere_montekhat(172,16,d)
plot(d,khatsg,type='n', ylim=c(-0.1,0.15),xlim=c(0,pi),xaxt = "n",
     ylab = expression(K - CSR),xlab = expression("Spherical Angle"))
axis(1, at = c(0,pi/6, pi/3, pi/2, 2*pi/3, 5*pi/6, pi),
     labels = expression(0,pi/6, pi/3, pi/2, 2*pi/3, 5*pi/6, pi))
polygon(c(d, rev(d)), c(Kcig[2,], rev(Kcig[16,])),col = "grey79", border = FALSE)
lines(d,khatsg,col = 4, lwd=2)
lines(y=c(0,0),x=c(0,pi),type='l',lty=2,lwd=2)
}
\seealso{
\code{\link{sphere_khat}, \link{GUAN}}
}

