% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_2d.R
\name{hist_2d}
\alias{hist_2d}
\title{hist_2d}
\usage{
hist_2d(
  x,
  y,
  breaks_x,
  breaks_y,
  same.scale = FALSE,
  na.rm = TRUE,
  FUN = base::length
)
}
\arguments{
\item{x}{either a numerical vector to be partitioned or a matrix of 2 numerical columns to
be partitioned.}

\item{y}{a numerical vector to be partitioned. Not required if x is a matrix.}

\item{breaks_x}{a numerical vector. Contains the breaks related to x for the
histogram}

\item{breaks_y}{a numerical vector. Contains the breaks related to y for the
histogram}

\item{same.scale}{logical. Default to FALSE. If TRUE, breaks_x will be used
for x and y}

\item{na.rm}{logical. Default to TRUE. Indicates whether missing values
should be removed}

\item{FUN}{function used to summarize bin contents.}
}
\value{
Using a given set of breaks per each variable, the function returns :
\describe{
\item{Hist.Values}{a matrix with in rows class intervals of x and in columns
class intervals of y. Contingency table is returned if FUN=length}
\item{breaks_x, breaks_y }{ same as the inputs of the function }
\item{Midpoints.x, Midpoints.y }{the midpoints for each bin per variable }
\item{nobs.x , nobs.y }{number of observations of x and y  }
\item{n.bins }{ vector of 2 elements containing the number of bins for
x and y }
}
}
\description{
This function results from a modification of the
\code{\link[gplots:hist2d]{hist2d}} function of the gplots package in order
to build the 2D histogram with breaks directly provided as inputs of the
new function.
}
\details{
The default function used for the argument FUN is the function
length. When another function is used, it is applied on x, or on the first column of x
if this is a two-column matrix. The lower limit of each class interval is
included in the class and the upper limit is not.
}
\examples{
set.seed(45)
hist_2d(x = rnorm(1000),
        y = rnorm( 1000,5,0.1),
        breaks_x = seq(-4, 4, by =1),
        breaks_y = seq(2, 8, by =1))
}
